/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1bSDK;
import com.appsflyer.internal.AFg1uSDK;
import com.appsflyer.internal.AFg1xSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFg1wSDK
extends AFg1xSDK {
    public final Map<String, Object> AFInAppEventParameterName = new HashMap<String, Object>();
    @NonNull
    private final ExecutorService AFInAppEventType;

    public AFg1wSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService) {
        super("store", "google", runnable);
        this.AFInAppEventType = executorService;
    }

    private static boolean AFInAppEventParameterName(@NonNull Context context) {
        if (!AFg1wSDK.values(context)) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFa1bSDK.AFInAppEventParameterName(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                com.appsflyer.AFLogger.afDebugLog("Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            com.appsflyer.AFLogger.afRDLog("Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        com.appsflyer.AFLogger.afDebugLog("Install referrer is not allowed");
        return false;
    }

    @Override
    public final void valueOf(Context context) {
        if (!AFg1wSDK.AFInAppEventParameterName(context)) {
            return;
        }
        AFg1wSDK aFg1wSDK = this;
        this.afDebugLog = System.currentTimeMillis();
        aFg1wSDK.AFLogger = AFg1uSDK.AFa1xSDK.AFKeystoreWrapper;
        aFg1wSDK.addObserver(new Observer(aFg1wSDK){
            private /* synthetic */ AFg1uSDK AFKeystoreWrapper;
            {
                this.AFKeystoreWrapper = aFg1uSDK;
            }

            public final void update(Observable observable, Object object) {
                this.AFKeystoreWrapper.AFKeystoreWrapper.run();
            }
        });
        try {
            aFg1wSDK = InstallReferrerClient.newBuilder((Context)context).build();
            com.appsflyer.AFLogger.afDebugLog("Connecting to Install Referrer Library...");
            aFg1wSDK.startConnection(new InstallReferrerStateListener(){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int n) {
                    AFg1wSDK.this.AFInAppEventType.execute(() -> AFg1wSDK.values(AFg1wSDK.this, this.val$referrerClient, this.val$context, n));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    com.appsflyer.AFLogger.afDebugLog("Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("referrerClient -> startConnection", throwable);
            return;
        }
    }

    static /* synthetic */ void values(AFg1wSDK aFg1wSDK, InstallReferrerClient installReferrerClient, Context context, int n) {
        aFg1wSDK.AFInAppEventParameterName.put("code", String.valueOf(n));
        String string = "com.android.vending";
        aFg1wSDK.valueOf.put("api_ver", AFa1bSDK.AFKeystoreWrapper(context, string));
        aFg1wSDK.valueOf.put("api_ver_name", AFa1bSDK.values(context, string));
        switch (n) {
            case 0: {
                aFg1wSDK.valueOf.put("response", "OK");
                try {
                    com.appsflyer.AFLogger.afDebugLog("InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            aFg1wSDK.AFInAppEventParameterName.put("val", object);
                            aFg1wSDK.valueOf.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        aFg1wSDK.AFInAppEventParameterName.put("clk", Long.toString(l));
                        aFg1wSDK.valueOf.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        aFg1wSDK.AFInAppEventParameterName.put("install", Long.toString(l2));
                        aFg1wSDK.valueOf.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            aFg1wSDK.AFInAppEventParameterName.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("some method not exist", noSuchMethodError);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            aFg1wSDK.valueOf.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    com.appsflyer.AFLogger.afWarnLog("ReferrerClient: InstallReferrer is not ready");
                    aFg1wSDK.AFInAppEventParameterName.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    com.appsflyer.AFLogger.afWarnLog("Failed to get install referrer: " + throwable.getMessage());
                    aFg1wSDK.AFInAppEventParameterName.put("err", throwable.getMessage());
                    com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("Failed to get install referrer", throwable);
                }
                break;
            }
            case 2: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer FEATURE_NOT_SUPPORTED");
                aFg1wSDK.valueOf.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                aFg1wSDK.valueOf.put("response", "SERVICE_UNAVAILABLE");
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer not supported");
                break;
            }
            case 3: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer DEVELOPER_ERROR");
                aFg1wSDK.valueOf.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer SERVICE_DISCONNECTED");
                aFg1wSDK.valueOf.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                com.appsflyer.AFLogger.afWarnLog("responseCode not found.");
            }
        }
        com.appsflyer.AFLogger.afDebugLog("Install Referrer collected locally");
        aFg1wSDK.AFInAppEventType();
    }
}

