/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.appsflyer.AFExecutor;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerLibCore;
import com.appsflyer.deeplink.DeepLinkListener;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class AFDeepLinkManager {
    static final int \u0399 = (int)TimeUnit.SECONDS.toMillis(2L);
    public static final String DDL_SENT = "ddl_sent";
    @VisibleForTesting
    public static AFDeepLinkManager instance;
    @VisibleForTesting
    public static Intent trampolineIntent;
    static volatile boolean \u0131;
    public DeepLinkListener deepLinkListener;
    static String[] \u03b9;
    public static String[] \u01c3;
    public String contains;
    public Map<String, String> parameters;
    @Nullable
    public List<List<String>> deepLinkSearchPaths = new ArrayList<List<String>>();

    @VisibleForTesting
    public AFDeepLinkManager() {
    }

    public static AFDeepLinkManager getInstance() {
        if (instance == null) {
            instance = new AFDeepLinkManager();
        }
        return instance;
    }

    private static boolean \u03b9(String string) {
        if (\u03b9 == null) {
            return false;
        }
        if (string.contains("af_tranid=")) {
            return false;
        }
        AFLogger.afRDLog("Validate if link " + string + " belongs to ESP domains: " + Arrays.asList(\u03b9));
        try {
            return Arrays.asList(\u03b9).contains(new URL(string).getHost());
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    static void \u0269(Context context, Map<String, Object> map, Uri uri) {
        if (AFDeepLinkManager.\u03b9(uri.toString())) {
            \u0131 = true;
            AFExecutor aFExecutor = AFExecutor.getInstance();
            if (aFExecutor.\u0131 == null) {
                aFExecutor.\u0131 = Executors.newSingleThreadScheduledExecutor(aFExecutor.\u0269);
            }
            aFExecutor.\u0131.execute(new Runnable(uri, map, context){
                private /* synthetic */ Uri \u03b9;
                private /* synthetic */ Map \u0399;
                private /* synthetic */ Context \u0131;
                {
                    this.\u03b9 = uri;
                    this.\u0399 = map;
                    this.\u0131 = context;
                }

                @Override
                public final void run() {
                    Map map;
                    long l2 = System.currentTimeMillis();
                    String string = this.\u03b9.toString();
                    Integer n2 = null;
                    String string2 = null;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = 0; i < 5; ++i) {
                        map = 1.\u03b9(Uri.parse((String)string));
                        string = (String)map.get("res");
                        n2 = (Integer)map.get("status");
                        string2 = (String)map.get("error");
                        if (string == null || !AFDeepLinkManager.\u03b9(string)) break;
                        if (i >= 4) continue;
                        ((AbstractCollection)arrayList).add(string);
                    }
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("res", string != null ? string : "");
                    hashMap.put("status", n2 != null ? n2 : -1);
                    if (string2 != null) {
                        hashMap.put("error", string2);
                    }
                    if (!((AbstractCollection)arrayList).isEmpty()) {
                        hashMap.put("redirects", arrayList);
                    }
                    hashMap.put("latency", System.currentTimeMillis() - l2);
                    map = this.\u0399;
                    synchronized (map) {
                        this.\u0399.put("af_deeplink_r", hashMap);
                        this.\u0399.put("af_deeplink", this.\u03b9.toString());
                    }
                    AppsFlyerLibCore.getInstance().handleDeepLinkCallback(this.\u0131, this.\u0399, string != null ? Uri.parse((String)string) : this.\u03b9);
                    \u0131 = false;
                }

                private static Map<String, Object> \u03b9(Uri uri) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    try {
                        AFLogger.afDebugLog("ESP deeplink resolving is started: " + uri.toString());
                        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(uri.toString()).openConnection();
                        httpURLConnection.setInstanceFollowRedirects(false);
                        httpURLConnection.setReadTimeout(\u0399);
                        httpURLConnection.setConnectTimeout(\u0399);
                        httpURLConnection.setRequestProperty("User-agent", "Dalvik/2.1.0 (Linux; U; Android 6.0.1; Nexus 5 Build/M4B30Z)");
                        httpURLConnection.setRequestProperty("af-esp", "6.1.3");
                        int n2 = httpURLConnection.getResponseCode();
                        ((AbstractMap)hashMap).put("status", n2);
                        if (300 <= n2 && n2 <= 305) {
                            ((AbstractMap)hashMap).put("res", httpURLConnection.getHeaderField("Location"));
                        }
                        httpURLConnection.disconnect();
                        AFLogger.afDebugLog("ESP deeplink resolving is finished");
                    }
                    catch (Throwable throwable) {
                        ((AbstractMap)hashMap).put("error", throwable.getLocalizedMessage());
                        AFLogger.afErrorLog(throwable.getMessage(), throwable);
                    }
                    return hashMap;
                }
            });
        } else {
            AppsFlyerLibCore.getInstance().handleDeepLinkCallback(context, map, uri);
        }
        trampolineIntent = null;
    }

    final boolean \u01c3(Intent intent, Context context, Map<String, Object> map) {
        Object object;
        Uri uri;
        Uri uri2;
        String string;
        block11: {
            Object object2;
            string = "af_consumed";
            Intent intent2 = intent;
            Uri uri3 = null;
            if (intent2 != null && "android.intent.action.VIEW".equals(intent2.getAction())) {
                uri3 = intent2.getData();
            }
            uri2 = uri3;
            intent2 = trampolineIntent;
            uri3 = null;
            if (intent2 != null && "android.intent.action.VIEW".equals(intent2.getAction())) {
                uri3 = intent2.getData();
            }
            uri = uri3;
            Map<String, Object> map2 = map;
            Intent intent3 = intent;
            AFDeepLinkManager aFDeepLinkManager = this;
            Bundle bundle = intent3.getExtras();
            if (aFDeepLinkManager.deepLinkSearchPaths == null || aFDeepLinkManager.deepLinkSearchPaths.isEmpty() || bundle == null) {
                object2 = null;
            } else {
                for (List<String> list : aFDeepLinkManager.deepLinkSearchPaths) {
                    String string2;
                    Uri uri4;
                    Iterator<String> iterator;
                    Bundle bundle2 = bundle;
                    List<String> list2 = list;
                    if ((list == null ? null : (!(iterator = list2.iterator()).hasNext() ? null : (uri4 = (string2 = bundle2.getString(iterator.next())) == null ? null : AFDeepLinkManager.\u01c3(string2, iterator)))) == null) continue;
                    AFLogger.afDebugLog("Found deeplink in push payload at " + list.toString());
                    AppsFlyerLibCore.\u0131(map2).put("payloadKey", aFDeepLinkManager.deepLinkSearchPaths);
                    object2 = uri4;
                    break block11;
                }
                object2 = object = null;
            }
        }
        if (uri2 != null) {
            if (!intent.hasExtra(string)) {
                intent.putExtra(string, System.currentTimeMillis());
                AFDeepLinkManager.\u0269(context, map, uri2);
                return true;
            }
            AFLogger.afInfoLog("skipping re-use of previously consumed deep link: " + uri2.toString() + " w/af_consumed");
            return false;
        }
        if (uri != null) {
            if (!trampolineIntent.hasExtra(string)) {
                trampolineIntent.putExtra(string, System.currentTimeMillis());
                AFDeepLinkManager.\u0269(context, map, uri);
                return true;
            }
            AFLogger.afInfoLog("skipping re-use of previously consumed trampoline deep link: " + uri.toString() + " w/af_consumed");
            return false;
        }
        if (object != null) {
            if (!intent.hasExtra(string)) {
                intent.putExtra(string, System.currentTimeMillis());
                AFDeepLinkManager.\u0269(context, map, (Uri)object);
                return true;
            }
            AFLogger.afInfoLog("skipping re-use of previously consumed deep link from push: " + object.toString() + " w/af_consumed");
            return false;
        }
        AFLogger.afDebugLog("No deep link detected");
        return false;
    }

    @Nullable
    private static Uri \u01c3(Object object, Iterator<String> iterator) {
        while (object != JSONObject.NULL) {
            if (!iterator.hasNext()) {
                Uri uri = Uri.parse((String)object.toString());
                if (uri != null && uri.getScheme() != null && uri.getHost() != null) {
                    return uri;
                }
                return null;
            }
            try {
                object = new JSONObject(object.toString()).get(iterator.next());
            }
            catch (JSONException jSONException) {
                return null;
            }
        }
        return null;
    }

    protected void collectIntentsFromActivities(Intent intent) {
        Intent intent2 = intent;
        Uri uri = null;
        if (intent2 != null && "android.intent.action.VIEW".equals(intent2.getAction())) {
            uri = intent2.getData();
        }
        if (uri != null && intent != trampolineIntent) {
            trampolineIntent = intent;
        }
    }
}

