/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import com.appsflyer.AndroidUtils;
import com.appsflyer.AppsFlyerLibCore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class EventDataCollector {
    private final Application \u01c3;
    private final SharedPreferences \u03b9;

    public EventDataCollector(Context context) {
        this.\u01c3 = (Application)context.getApplicationContext();
        this.\u03b9 = AppsFlyerLibCore.getSharedPreferences((Context)this.\u01c3);
    }

    public String signature() throws CertificateException, NoSuchAlgorithmException, PackageManager.NameNotFoundException {
        return AndroidUtils.signature(this.\u01c3.getPackageManager(), this.\u01c3.getPackageName());
    }

    public long bootTime() {
        return System.currentTimeMillis() - SystemClock.elapsedRealtime();
    }

    public String disk() {
        long l2;
        long l3;
        StatFs statFs = new StatFs(Environment.getDataDirectory().getAbsolutePath());
        if (Build.VERSION.SDK_INT >= 18) {
            long l4 = statFs.getBlockSizeLong();
            l3 = statFs.getAvailableBlocksLong() * l4;
            l2 = statFs.getBlockCountLong() * l4;
        } else {
            int n2 = statFs.getBlockSize();
            l3 = statFs.getAvailableBlocks() * n2;
            l2 = statFs.getBlockCount() * n2;
        }
        double d2 = Math.pow(2.0, 20.0);
        l3 = (long)((double)l3 / d2);
        l2 = (long)((double)l2 / d2);
        return l3 + "/" + l2;
    }

    public long getLong(String string) {
        return this.\u03b9.getLong(string, 0L);
    }

    @Nullable
    public String getString(String string) {
        return this.\u03b9.getString(string, null);
    }

    public void set(String string, long l2) {
        this.\u03b9.edit().putLong(string, l2).apply();
    }

    public void set(String string, String string2) {
        this.\u03b9.edit().putString(string, string2).apply();
    }

    public void init() {
        if (this.\u0269()) {
            this.set("init_ts", System.currentTimeMillis());
        }
    }

    public void foreground() {
        if (this.\u0269()) {
            this.set("fg_ts", System.currentTimeMillis());
        }
    }

    private boolean \u0269() {
        return AppsFlyerLibCore.getInstance().getLaunchCounter(this.\u03b9, false) == 0;
    }
}

