/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.support.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.AndroidUtils;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class ContentFetcher<T> {
    public final Context context;
    public final String authority;
    private final String[] \u03b9;
    private final long \u0399;
    private FutureTask<T> \u0269 = new FutureTask(new Callable<T>(this){
        private /* synthetic */ ContentFetcher \u01c3;
        {
            this.\u01c3 = contentFetcher;
        }

        @Override
        public final T call() {
            if (this.\u01c3.valid()) {
                return this.\u01c3.query();
            }
            return null;
        }
    });

    public ContentFetcher(Context context, String string, long l, String ... stringArray) {
        this.context = context;
        this.authority = string;
        this.\u03b9 = stringArray;
        this.\u0399 = l;
    }

    public void start() {
        new Thread(this.\u0269).start();
    }

    @Nullable
    public T get() {
        try {
            return this.\u0269.get(this.\u0399, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.onError(exception);
            return null;
        }
    }

    public boolean valid() {
        try {
            ProviderInfo providerInfo = this.context.getPackageManager().resolveContentProvider(this.authority, 128);
            return providerInfo != null && Arrays.asList(this.\u03b9).contains(AndroidUtils.signature(this.context.getPackageManager(), providerInfo.packageName));
        }
        catch (PackageManager.NameNotFoundException | NoSuchAlgorithmException | CertificateException throwable) {
            this.onError((Exception)throwable);
            return false;
        }
    }

    protected void onError(Exception exception) {
        AFLogger.afErrorLog(exception.getMessage(), exception);
    }

    protected abstract T query();
}

