/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.support.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.AndroidUtils;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class ContentFetcher<T> {
    public final Context context;
    public final String authority;
    private final String \u0131;
    private final long \u03b9;
    private FutureTask<T> \u01c3 = new FutureTask(new Callable<T>(this){
        private /* synthetic */ ContentFetcher \u0399;
        {
            this.\u0399 = contentFetcher;
        }

        @Override
        public final T call() {
            if (this.\u0399.valid()) {
                return this.\u0399.query();
            }
            return null;
        }
    });

    public ContentFetcher(Context context, String string, String string2, long l2) {
        this.context = context;
        this.authority = string;
        this.\u0131 = string2;
        this.\u03b9 = l2;
    }

    public void start() {
        new Thread(this.\u01c3).start();
    }

    @Nullable
    public T get() {
        try {
            return this.\u01c3.get(this.\u03b9, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.onError(exception);
            return null;
        }
    }

    public boolean valid() {
        try {
            ProviderInfo providerInfo = this.context.getPackageManager().resolveContentProvider(this.authority, 128);
            return providerInfo != null && AndroidUtils.signature(this.context.getPackageManager(), providerInfo.packageName).equalsIgnoreCase(this.\u0131);
        }
        catch (PackageManager.NameNotFoundException | NoSuchAlgorithmException | CertificateException throwable) {
            this.onError((Exception)throwable);
            return false;
        }
    }

    protected void onError(Exception exception) {
        AFLogger.afErrorLog(exception.getMessage(), exception);
    }

    protected abstract T query();
}

