/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.VisibleForTesting;
import com.appsflyer.AFExecutor;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerLibCore;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class AFDeepLinkManager {
    static final int \u0269 = (int)TimeUnit.SECONDS.toMillis(2L);
    static volatile boolean \u03b9;
    static String[] \u0131;
    public static String[] \u01c3;
    @VisibleForTesting
    public static AFDeepLinkManager instance;
    @VisibleForTesting
    public static Uri trampolineUri;

    private AFDeepLinkManager() {
    }

    public static AFDeepLinkManager getInstance() {
        if (instance == null) {
            instance = new AFDeepLinkManager();
        }
        return instance;
    }

    private static boolean \u01c3(String string) {
        if (\u0131 == null) {
            return false;
        }
        if (string.contains("af_tranid=")) {
            return false;
        }
        AFLogger.afRDLog("Validate ESP URLs :" + Arrays.asList(\u0131));
        String[] stringArray = \u0131;
        int n2 = \u0131.length;
        for (int j = 0; j < n2; ++j) {
            String string2 = stringArray[j];
            if (!string.contains("://".concat(String.valueOf(string2)))) continue;
            AFLogger.afRDLog("Deeplink matches ESP domain: ".concat(String.valueOf(string2)));
            return true;
        }
        return false;
    }

    static void \u0399(Context context, Map<String, Object> map, Uri uri) {
        if (AFDeepLinkManager.\u01c3(uri.toString())) {
            \u03b9 = true;
            AFExecutor aFExecutor = AFExecutor.getInstance();
            if (aFExecutor.\u0131 == null) {
                aFExecutor.\u0131 = Executors.newSingleThreadScheduledExecutor(aFExecutor.\u0269);
            }
            aFExecutor.\u0131.execute(new Runnable(uri, map, context){
                private /* synthetic */ Uri \u0131;
                private /* synthetic */ Map \u03b9;
                private /* synthetic */ Context \u0269;
                {
                    this.\u0131 = uri;
                    this.\u03b9 = map;
                    this.\u0269 = context;
                }

                @Override
                public final void run() {
                    long l;
                    Object object;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    long l2 = System.currentTimeMillis();
                    Object object2 = null;
                    try {
                        AFLogger.afDebugLog("ESP deeplink resolving is started: " + this.\u0131.toString());
                        object = (HttpURLConnection)new URL(this.\u0131.toString()).openConnection();
                        ((HttpURLConnection)object).setInstanceFollowRedirects(false);
                        ((URLConnection)object).setReadTimeout(\u0269);
                        ((URLConnection)object).setConnectTimeout(\u0269);
                        ((URLConnection)object).setRequestProperty("User-agent", "Dalvik/2.1.0 (Linux; U; Android 6.0.1; Nexus 5 Build/M4B30Z)");
                        ((URLConnection)object).connect();
                        AFLogger.afDebugLog("ESP deeplink resolving is finished");
                        hashMap.put("status", String.valueOf(((HttpURLConnection)object).getResponseCode()));
                        if (((HttpURLConnection)object).getResponseCode() >= 300 && ((HttpURLConnection)object).getResponseCode() <= 305) {
                            object2 = Uri.parse((String)((URLConnection)object).getHeaderField("Location"));
                        }
                        l = System.currentTimeMillis() - l2;
                        ((HttpURLConnection)object).disconnect();
                    }
                    catch (Throwable throwable) {
                        hashMap.put("error", throwable.getLocalizedMessage());
                        hashMap.put("status", "-1");
                        l = System.currentTimeMillis() - l2;
                        AFLogger.afErrorLog(throwable.getMessage(), throwable);
                    }
                    hashMap.put("latency", Long.toString(l));
                    if (object2 != null) {
                        hashMap.put("res", object2.toString());
                    } else {
                        hashMap.put("res", "");
                    }
                    object = this.\u03b9;
                    synchronized (object) {
                        this.\u03b9.put("af_deeplink_r", hashMap);
                        this.\u03b9.put("af_deeplink", this.\u0131.toString());
                    }
                    \u03b9 = false;
                    object = object2 != null ? object2 : this.\u0131;
                    AppsFlyerLibCore.getInstance().handleDeepLinkCallback(this.\u0269, this.\u03b9, (Uri)object);
                }
            });
        } else {
            AppsFlyerLibCore.getInstance().handleDeepLinkCallback(context, map, uri);
        }
        trampolineUri = null;
    }

    static void \u0269(Intent intent, Context context, Map<String, Object> map) {
        Uri uri;
        Intent intent2 = intent;
        Uri uri2 = null;
        if (intent2 != null && "android.intent.action.VIEW".equals(intent2.getAction())) {
            uri2 = intent2.getData();
        }
        if ((uri = uri2) != null) {
            if (!intent.hasExtra("af_consumed")) {
                intent.putExtra("af_consumed", System.currentTimeMillis());
                AFDeepLinkManager.\u0399(context, map, uri);
                return;
            }
            AFLogger.afInfoLog("skipping re-use of previously consumed deep link: " + uri.toString() + " w/af_consumed");
            return;
        }
        if (trampolineUri != null) {
            AFLogger.afInfoLog("using trampoline Intent fallback with URI: " + trampolineUri);
            AFDeepLinkManager.\u0399(context, map, trampolineUri);
            return;
        }
        if (AppsFlyerLibCore.getInstance().latestDeepLink != null) {
            AFLogger.afInfoLog("using Unity/plugin Intent fallback with URI: " + AppsFlyerLibCore.getInstance().latestDeepLink.toString());
            AFDeepLinkManager.\u0399(context, map, AppsFlyerLibCore.getInstance().latestDeepLink);
            return;
        }
        AFLogger.afDebugLog("No deep link detected");
    }

    protected void collectIntentsFromActivities(Intent intent) {
        Intent intent2 = intent;
        Uri uri = null;
        if (intent2 != null && "android.intent.action.VIEW".equals(intent2.getAction())) {
            uri = intent2.getData();
        }
        if (uri != null && intent.getData() != trampolineUri) {
            trampolineUri = intent.getData();
        }
    }
}

