/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import com.appsflyer.AFLogger;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import javax.security.auth.x500.X500Principal;

class AFKeystoreWrapper {
    private final Object \u02cb = new Object();
    private KeyStore \u02cf;
    private Context \u0971;
    private String \u02ca;
    private int \u02ce;

    public AFKeystoreWrapper(Context object) {
        this.\u0971 = object;
        this.\u02ca = "";
        this.\u02ce = 0;
        object = this;
        AFLogger.afInfoLog("Initialising KeyStore..");
        try {
            object.\u02cf = KeyStore.getInstance("AndroidKeyStore");
            object.\u02cf.load(null);
            return;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            AFLogger.afErrorLog("Couldn't load keystore instance of type: AndroidKeyStore", exception);
            return;
        }
    }

    final void \u02cf(String string) {
        this.\u02ca = string;
        this.\u02ce = 0;
        AFKeystoreWrapper aFKeystoreWrapper = this;
        aFKeystoreWrapper.\u02ca(aFKeystoreWrapper.\u02cf());
    }

    final void \u02ca() {
        Object object = this.\u02cf();
        Object object2 = this.\u02cb;
        synchronized (object2) {
            ++this.\u02ce;
            String string = object;
            object = this;
            AFLogger.afInfoLog("Deleting key with alias: ".concat(String.valueOf(string)));
            try {
                Object object3 = ((AFKeystoreWrapper)object).\u02cb;
                synchronized (object3) {
                    ((AFKeystoreWrapper)object).\u02cf.deleteEntry(string);
                }
            }
            catch (KeyStoreException keyStoreException) {
                AFLogger.afErrorLog("Exception " + keyStoreException.getMessage() + " occurred", keyStoreException);
            }
        }
        AFKeystoreWrapper aFKeystoreWrapper = this;
        aFKeystoreWrapper.\u02ca(aFKeystoreWrapper.\u02cf());
    }

    final boolean \u02ce() {
        boolean bl = false;
        Object object = this.\u02cb;
        synchronized (object) {
            if (this.\u02cf != null) {
                try {
                    String[] stringArray = this.\u02cf.aliases();
                    while (stringArray.hasMoreElements()) {
                        String[] stringArray2 = stringArray.nextElement();
                        if (stringArray2 == null || !stringArray2.startsWith("com.appsflyer")) continue;
                        stringArray = stringArray2.split(",");
                        if (stringArray.length == 3) {
                            AFLogger.afInfoLog("Found a matching AF key with alias:\n".concat(String.valueOf(stringArray2)));
                            bl = true;
                            stringArray2 = stringArray[1].trim().split("=");
                            stringArray = stringArray[2].trim().split("=");
                            if (stringArray2.length == 2 && stringArray.length == 2) {
                                this.\u02ca = stringArray2[1].trim();
                                this.\u02ce = Integer.parseInt(stringArray[1].trim());
                            }
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    AFLogger.afErrorLog("Couldn't list KeyStore Aliases: " + throwable.getClass().getName(), throwable);
                }
            }
        }
        return bl;
    }

    private void \u02ca(String object) {
        AFLogger.afInfoLog("Creating a new key with alias: ".concat(String.valueOf(object)));
        try {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(1, 5);
            KeyGenParameterSpec keyGenParameterSpec = null;
            Object object2 = this.\u02cb;
            synchronized (object2) {
                if (!this.\u02cf.containsAlias((String)object)) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        keyGenParameterSpec = new KeyGenParameterSpec.Builder((String)object, 3).setCertificateSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setCertificateSerialNumber(BigInteger.ONE).setCertificateNotBefore(calendar.getTime()).setCertificateNotAfter(calendar2.getTime()).build();
                    } else if (Build.VERSION.SDK_INT >= 18 && !"OPPO".equals(Build.BRAND)) {
                        keyGenParameterSpec = new KeyPairGeneratorSpec.Builder(this.\u0971).setAlias((String)object).setSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setSerialNumber(BigInteger.ONE).setStartDate(calendar.getTime()).setEndDate(calendar2.getTime()).build();
                    }
                    object = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
                    ((KeyPairGenerator)object).initialize((AlgorithmParameterSpec)keyGenParameterSpec);
                    ((KeyPairGeneratorSpi)object).generateKeyPair();
                } else {
                    AFLogger.afInfoLog("Alias already exists: ".concat(String.valueOf(object)));
                }
                return;
            }
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("Exception " + throwable.getMessage() + " occurred", throwable);
            return;
        }
    }

    private String \u02cf() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("com.appsflyer,");
        Object object = this.\u02cb;
        synchronized (object) {
            stringBuilder.append("KSAppsFlyerId=").append(this.\u02ca).append(",");
            stringBuilder.append("KSAppsFlyerRICounter=").append(this.\u02ce);
        }
        return ((Object)stringBuilder).toString();
    }

    final String \u0971() {
        Object object = this.\u02cb;
        synchronized (object) {
            return this.\u02ca;
        }
    }

    final int \u02cb() {
        Object object = this.\u02cb;
        synchronized (object) {
            return this.\u02ce;
        }
    }
}

