/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.support.annotation.NonNull;
import android.util.Log;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.u;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class AFLogger {
    private static long starTime = System.currentTimeMillis();

    /*
     * WARNING - void declaration
     */
    public static void afInfoLog(String logMessage, boolean shouldRemoteDebug) {
        void var1_1;
        if (AFLogger.shouldLog(LogLevel.INFO)) {
            Log.i((String)"AppsFlyer_4.8.7", (String)AFLogger.getMessage(logMessage));
        }
        if (var1_1 != false) {
            String string;
            u.getInstance().addLogEntry("I", AFLogger.getMessage(string, true));
        }
    }

    public static void resetDeltaTime() {
        starTime = System.currentTimeMillis();
    }

    @NonNull
    private static String getMessage(String logMessage) {
        return AFLogger.getMessage(logMessage, false);
    }

    @NonNull
    private static String getMessage(String logMessage, boolean forceTimerDelta) {
        String string;
        if (forceTimerDelta || LogLevel.VERBOSE.getLevel() == AppsFlyerProperties.getInstance().getLogLevel()) {
            return "(" + AFLogger.timeString(System.currentTimeMillis() - starTime) + ") " + logMessage;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    static void afDebugLog(String debugLogMessage, boolean shouldRemoteDebug) {
        void var1_1;
        if (AFLogger.shouldLog(LogLevel.DEBUG)) {
            Log.d((String)"AppsFlyer_4.8.7", (String)AFLogger.getMessage(debugLogMessage));
        }
        if (var1_1 != false) {
            String string;
            u.getInstance().addLogEntry("D", AFLogger.getMessage(string, true));
        }
    }

    /*
     * WARNING - void declaration
     */
    static void afErrorLog(String errorLogMessage, Throwable ex, boolean shouldRemoteDebug, boolean shouldOutputToLog) {
        void var2_2;
        void var3_3;
        if (AFLogger.shouldLog(LogLevel.ERROR) && var3_3 != false) {
            String string;
            Log.e((String)"AppsFlyer_4.8.7", (String)AFLogger.getMessage(string), (Throwable)ex);
        }
        if (var2_2 != false) {
            void var1_1;
            u.getInstance().addExceptionEvent((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void afWarnLog(String warningLogMessage, boolean shouldRemoteDebug) {
        void var1_1;
        if (AFLogger.shouldLog(LogLevel.WARNING)) {
            Log.w((String)"AppsFlyer_4.8.7", (String)AFLogger.getMessage(warningLogMessage));
        }
        if (var1_1 != false) {
            String string;
            u.getInstance().addLogEntry("W", AFLogger.getMessage(string, true));
        }
    }

    public static void afRDLog(String rdLogMessage) {
        String string;
        if (AFLogger.shouldLog(LogLevel.VERBOSE)) {
            Log.v((String)"AppsFlyer_4.8.7", (String)AFLogger.getMessage(rdLogMessage));
        }
        u.getInstance().addLogEntry("V", AFLogger.getMessage(string, true));
    }

    private static boolean shouldLog(LogLevel level) {
        return level.getLevel() <= AppsFlyerProperties.getInstance().getLogLevel();
    }

    static void afLogForce(String logMessage) {
        String string;
        if (!AFLogger.noLogsAllowed()) {
            Log.d((String)"AppsFlyer_4.8.7", (String)AFLogger.getMessage(logMessage));
        }
        u.getInstance().addLogEntry("F", string);
    }

    private static boolean noLogsAllowed() {
        return AppsFlyerProperties.getInstance().isLogsDisabledCompletely();
    }

    public static void afDebugLog(String debugLogMessage) {
        AFLogger.afDebugLog(debugLogMessage, true);
    }

    public static void afInfoLog(String logMessage) {
        AFLogger.afInfoLog(logMessage, true);
    }

    /*
     * WARNING - void declaration
     */
    public static void afErrorLog(String errorLogMessage, Throwable ex) {
        void var1_1;
        AFLogger.afErrorLog(errorLogMessage, (Throwable)var1_1, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void afErrorLog(String errorLogMessage, Throwable ex, boolean shouldOutputToLog) {
        void var2_2;
        void var1_1;
        AFLogger.afErrorLog(errorLogMessage, (Throwable)var1_1, true, (boolean)var2_2);
    }

    public static void afWarnLog(String warningLogMessage) {
        AFLogger.afWarnLog(warningLogMessage, true);
    }

    static String timeString(long gap) {
        long l2;
        long l3 = TimeUnit.MILLISECONDS.toHours(gap);
        long l4 = TimeUnit.MILLISECONDS.toMinutes(gap -= TimeUnit.HOURS.toMillis(l3));
        long l5 = TimeUnit.MILLISECONDS.toSeconds(gap -= TimeUnit.MINUTES.toMillis(l4));
        gap -= TimeUnit.SECONDS.toMillis(l5);
        long l6 = TimeUnit.MILLISECONDS.toMillis(l2);
        return String.format(Locale.getDefault(), "%02d:%02d:%02d:%03d", l3, l4, l5, l6);
    }

    public static enum LogLevel {
        NONE(0),
        ERROR(1),
        WARNING(2),
        INFO(3),
        DEBUG(4),
        VERBOSE(5);

        private int level;

        /*
         * WARNING - void declaration
         */
        private LogLevel(int s2) {
            void var3_3;
            this.level = var3_3;
        }

        public final int getLevel() {
            return this.level;
        }
    }
}

