/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import com.appsflyer.AFLogger;
import com.appsflyer.a;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import javax.security.auth.x500.X500Principal;

class AFKeystoreWrapper {
    private final Object lock = new Object();
    private KeyStore keystore;
    private Context context;
    private String uid;
    private int reInstallCounter;

    /*
     * WARNING - void declaration
     */
    public AFKeystoreWrapper(Context context) {
        void var1_1;
        this.context = var1_1;
        this.uid = "";
        this.reInstallCounter = 0;
        this.initKeyStore();
    }

    private void initKeyStore() {
        AFLogger.afInfoLog("Initialising KeyStore..");
        try {
            this.keystore = KeyStore.getInstance("AndroidKeyStore");
            this.keystore.load(null);
            return;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            AFLogger.afErrorLog("Couldn't load keystore instance of type: AndroidKeyStore", exception);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void createFirstInstallData(String appsFlyerUID) {
        void var1_1;
        this.uid = var1_1;
        this.reInstallCounter = 0;
        this.createKey(this.generateAliasString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementReInstallCounter() {
        String string = this.generateAliasString();
        Object object = this.lock;
        synchronized (object) {
            ++this.reInstallCounter;
            this.deleteKey(string);
        }
        this.createKey(this.generateAliasString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean loadData() {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.keystore != null) {
                try {
                    String[] stringArray = this.keystore.aliases();
                    while (stringArray.hasMoreElements()) {
                        String[] stringArray2 = stringArray.nextElement();
                        if (stringArray2 == null || !this.isAppsFlyerPrefix((String)stringArray2)) continue;
                        stringArray = stringArray2.split(",");
                        if (stringArray.length == 3) {
                            AFLogger.afInfoLog("Found a matching AF key with alias:\n" + (String)stringArray2);
                            bl = true;
                            stringArray2 = stringArray[1].trim().split("=");
                            stringArray = stringArray[2].trim().split("=");
                            if (stringArray2.length == 2 && stringArray.length == 2) {
                                this.uid = stringArray2[1].trim();
                                this.reInstallCounter = Integer.parseInt(stringArray[1].trim());
                            }
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    AFLogger.afErrorLog("Couldn't list KeyStore Aliases: " + throwable.getClass().getName(), throwable);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createKey(String alias) {
        AFLogger.afInfoLog("Creating a new key with alias: " + alias);
        try {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(1, 5);
            KeyGenParameterSpec keyGenParameterSpec = null;
            Object object = this.lock;
            synchronized (object) {
                KeyPairGenerator keyPairGenerator;
                if (!this.keystore.containsAlias(alias)) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        keyGenParameterSpec = new KeyGenParameterSpec.Builder(alias, 3).setCertificateSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setCertificateSerialNumber(BigInteger.ONE).setCertificateNotBefore(calendar.getTime()).setCertificateNotAfter(calendar2.getTime()).build();
                    } else if (Build.VERSION.SDK_INT >= 18 && !a.isOPPODevice()) {
                        keyGenParameterSpec = new KeyPairGeneratorSpec.Builder(this.context).setAlias(alias).setSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setSerialNumber(BigInteger.ONE).setStartDate(calendar.getTime()).setEndDate(calendar2.getTime()).build();
                    }
                    keyPairGenerator = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
                    keyPairGenerator.initialize((AlgorithmParameterSpec)keyGenParameterSpec);
                    keyPairGenerator.generateKeyPair();
                } else {
                    AFLogger.afInfoLog("Alias already exists: " + (String)((Object)keyPairGenerator));
                }
            }
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("Exception " + throwable.getMessage() + " occurred", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void deleteKey(String alias) {
        AFLogger.afInfoLog("Deleting key with alias: " + alias);
        try {
            Object object = this.lock;
            synchronized (object) {
                void var1_1;
                this.keystore.deleteEntry((String)var1_1);
            }
        }
        catch (KeyStoreException keyStoreException) {
            AFLogger.afErrorLog("Exception " + keyStoreException.getMessage() + " occurred", keyStoreException);
        }
    }

    private boolean isAppsFlyerPrefix(String alias) {
        return alias.startsWith("com.appsflyer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateAliasString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("com.appsflyer,");
        Object object = this.lock;
        synchronized (object) {
            stringBuilder.append("KSAppsFlyerId=").append(this.uid).append(",");
            stringBuilder.append("KSAppsFlyerRICounter=").append(this.reInstallCounter);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getUid() {
        Object object = this.lock;
        synchronized (object) {
            return this.uid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getReInstallCounter() {
        Object object = this.lock;
        synchronized (object) {
            return this.reInstallCounter;
        }
    }
}

