/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.os.AsyncTask;
import android.os.Build;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;

public class AFExecutor {
    private static AFExecutor instance;
    private Executor afThreadPoolExecutor;
    private ScheduledExecutorService afScheduledThreadPoolExecutor;
    private Executor afSerialExecutor;

    private AFExecutor() {
    }

    public static AFExecutor getInstance() {
        if (instance == null) {
            instance = new AFExecutor();
        }
        return instance;
    }

    public Executor getSerialExecutor() {
        if (this.afSerialExecutor == null) {
            if (Build.VERSION.SDK_INT >= 11) {
                this.afSerialExecutor = AsyncTask.SERIAL_EXECUTOR;
            } else {
                return Executors.newSingleThreadExecutor();
            }
        }
        return this.afSerialExecutor;
    }

    public Executor getThreadPoolExecutor() {
        boolean bl = this.afThreadPoolExecutor == null || this.afThreadPoolExecutor instanceof ThreadPoolExecutor && (((ThreadPoolExecutor)this.afThreadPoolExecutor).isShutdown() || ((ThreadPoolExecutor)this.afThreadPoolExecutor).isTerminated() || ((ThreadPoolExecutor)this.afThreadPoolExecutor).isTerminating());
        if (bl) {
            if (Build.VERSION.SDK_INT >= 11) {
                this.afThreadPoolExecutor = AsyncTask.THREAD_POOL_EXECUTOR;
            } else {
                return Executors.newSingleThreadExecutor();
            }
        }
        return this.afThreadPoolExecutor;
    }

    ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        boolean bl = this.afScheduledThreadPoolExecutor == null || this.afScheduledThreadPoolExecutor.isShutdown() || this.afScheduledThreadPoolExecutor.isTerminated();
        if (bl) {
            this.afScheduledThreadPoolExecutor = Executors.newScheduledThreadPool(2);
        }
        return (ScheduledThreadPoolExecutor)this.afScheduledThreadPoolExecutor;
    }
}

