package com.appsflyer;

/**
 * Created by shacharaharon on 03/07/2016.
 */
class GcmToken {
    private static final int TOKEN_AGING_TIME = 2000;
    private long tokenTimestamp;
    private String token;
    private String instanceId;

    public GcmToken(long tokenTimestamp, String token, String instanceId) {
        this.tokenTimestamp = tokenTimestamp;
        this.token = token;
        this.instanceId = instanceId;
    }

    public GcmToken(String tokenTimestamp, String token, String instanceId) {
        if (tokenTimestamp == null) {
            this.tokenTimestamp = 0L;
        } else {
            this.tokenTimestamp = Long.valueOf(tokenTimestamp);
        }
        this.token = token;
        this.instanceId = instanceId;
    }


    public boolean update(GcmToken token) {
        return update(token.getTokenTimestamp(),token.getToken(),token.getInstanceId());
    }

    public boolean update(long tokenTimestamp, String token, String instanceId) {
        if (!token.equals(this.token) && tokenTimestamp - this.tokenTimestamp > TOKEN_AGING_TIME) {
            this.tokenTimestamp = tokenTimestamp;
            this.token = token;
            this.instanceId = instanceId;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return tokenTimestamp +","+ token +","+ instanceId;
    }

    public long getTokenTimestamp() {
        return tokenTimestamp;
    }

    public void setTokenTimestamp(long tokenTimestamp) {
        this.tokenTimestamp = tokenTimestamp;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }
}
