/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import com.appsflyer.AFLogger;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;

class AFKeystoreWrapper {
    private static final String AF_KEYSTORE_PREFIX = "com.appsflyer";
    public static final String AF_KEYSTORE_UID = "KSAppsFlyerId";
    public static final String AF_KEYSTORE_REINSTALL_COUNTER = "KSAppsFlyerRICounter";
    private static final String RSA_ALGORITHM = "RSA";
    private static final String PROVIDER_ANDROID_KEY_STORE = "AndroidKeyStore";
    private static final String CN_ANDROID_SDK_O_APPS_FLYER = "CN=AndroidSDK, O=AppsFlyer";
    private static final String AF_KEYSTORE_EXTERNAL_DELIMITER = ",";
    private static final int KEYSTORE_CERTIFICATE_VALIDITY_YEARS = 5;
    private static final String AF_KEYSTORE_INTERNAL_DELIMITER = "=";
    private final Object lock = new Object();
    private KeyStore keystore;
    private Context context;
    private String uid;
    private int reInstallCounter;

    public AFKeystoreWrapper(Context context) {
        this.context = context;
        this.uid = "";
        this.reInstallCounter = 0;
        this.initKeyStore();
    }

    private void initKeyStore() {
        AFLogger.afLog("Initialising KeyStore..");
        try {
            this.keystore = KeyStore.getInstance(PROVIDER_ANDROID_KEY_STORE);
            this.keystore.load(null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            AFLogger.afLog("Couldn't load keystore instance of type: AndroidKeyStore");
        }
    }

    public void createFirstInstallData(String appsFlyerUID) {
        this.uid = appsFlyerUID;
        this.reInstallCounter = 0;
        this.createKey(this.generateAliasString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementReInstallCounter() {
        String currentKeyAlias = this.generateAliasString();
        Object object = this.lock;
        synchronized (object) {
            ++this.reInstallCounter;
            this.deleteKey(currentKeyAlias);
        }
        this.createKey(this.generateAliasString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadData() {
        boolean isDataExists = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.keystore != null) {
                try {
                    Enumeration<String> aliases = this.keystore.aliases();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        if (alias == null || !this.isAppsFlyerPrefix(alias)) continue;
                        String[] afData = alias.split(AF_KEYSTORE_EXTERNAL_DELIMITER);
                        if (afData.length == 3) {
                            AFLogger.afLog("Found a matching AF key with alias:\n" + alias);
                            isDataExists = true;
                            String[] ksId = afData[1].trim().split(AF_KEYSTORE_INTERNAL_DELIMITER);
                            String[] ksRICounter = afData[2].trim().split(AF_KEYSTORE_INTERNAL_DELIMITER);
                            if (ksId.length == 2 && ksRICounter.length == 2) {
                                this.uid = ksId[1].trim();
                                this.reInstallCounter = Integer.parseInt(ksRICounter[1].trim());
                            }
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    AFLogger.afLog("Couldn't list KeyStore Aliases: " + e.getClass().getName());
                }
            }
        }
        return isDataExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createKey(String alias) {
        AFLogger.afLog("Creating a new key with alias: " + alias);
        try {
            Object object = this.lock;
            synchronized (object) {
                if (!this.keystore.containsAlias(alias)) {
                    Calendar start = Calendar.getInstance();
                    Calendar end = Calendar.getInstance();
                    end.add(1, 5);
                    KeyGenParameterSpec spec = null;
                    if (Build.VERSION.SDK_INT >= 23) {
                        spec = new KeyGenParameterSpec.Builder(alias, 3).setCertificateSubject(new X500Principal(CN_ANDROID_SDK_O_APPS_FLYER)).setCertificateSerialNumber(BigInteger.ONE).setCertificateNotBefore(start.getTime()).setCertificateNotAfter(end.getTime()).build();
                    } else if (Build.VERSION.SDK_INT >= 18) {
                        spec = new KeyPairGeneratorSpec.Builder(this.context).setAlias(alias).setSubject(new X500Principal(CN_ANDROID_SDK_O_APPS_FLYER)).setSerialNumber(BigInteger.ONE).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
                    }
                    KeyPairGenerator generator = KeyPairGenerator.getInstance(RSA_ALGORITHM, PROVIDER_ANDROID_KEY_STORE);
                    generator.initialize((AlgorithmParameterSpec)spec);
                    generator.generateKeyPair();
                } else {
                    AFLogger.afLog("Alias already exists: " + alias);
                }
            }
        }
        catch (Exception e) {
            AFLogger.afLog("Exception " + e.getMessage() + " occurred");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteKey(String alias) {
        AFLogger.afLog("Deleting key with alias: " + alias);
        try {
            Object object = this.lock;
            synchronized (object) {
                this.keystore.deleteEntry(alias);
            }
        }
        catch (KeyStoreException e) {
            AFLogger.afLog("Exception " + e.getMessage() + " occurred");
        }
    }

    private boolean isAppsFlyerPrefix(String alias) {
        return alias.startsWith(AF_KEYSTORE_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateAliasString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AF_KEYSTORE_PREFIX).append(AF_KEYSTORE_EXTERNAL_DELIMITER);
        Object object = this.lock;
        synchronized (object) {
            sb.append(AF_KEYSTORE_UID).append(AF_KEYSTORE_INTERNAL_DELIMITER).append(this.uid).append(AF_KEYSTORE_EXTERNAL_DELIMITER);
            sb.append(AF_KEYSTORE_REINSTALL_COUNTER).append(AF_KEYSTORE_INTERNAL_DELIMITER).append(this.reInstallCounter);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUid() {
        Object object = this.lock;
        synchronized (object) {
            return this.uid;
        }
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReInstallCounter() {
        Object object = this.lock;
        synchronized (object) {
            return this.reInstallCounter;
        }
    }

    public void setReInstallCounter(int reInstallCounter) {
        this.reInstallCounter = reInstallCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAllAFKeys() {
        Object object = this.lock;
        synchronized (object) {
            if (this.keystore != null) {
                try {
                    Enumeration<String> aliases = this.keystore.aliases();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        if (!this.isAppsFlyerPrefix(alias)) continue;
                        AFLogger.afLog("Found AF key. Removing: " + alias);
                        this.keystore.deleteEntry(alias);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

