package com.appsflyer;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import java.util.List;

public class SingleInstallBroadcastReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        String referrerTimestamp = AppsFlyerProperties.getInstance().getString("referrer_timestamp");
        long now = System.currentTimeMillis();
        if (referrerTimestamp != null && (now - Long.valueOf(referrerTimestamp) < 2000)) {
            return;
        }
        AFLogger.afLog("SingleInstallBroadcastReceiver called");
        AppsFlyerLib.getInstance().onReceive(context, intent);
        AppsFlyerProperties.getInstance().set("referrer_timestamp", String.valueOf(System.currentTimeMillis()));
    }
}
