/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import com.appsflyer.AFLogger;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;

class AFKeystoreWrapper {
    final Object \u02cf = new Object();
    KeyStore \u02cb;
    private Context \u0971;
    String \u02ca;
    int \u02ce;

    public AFKeystoreWrapper(Context context) {
        this.\u0971 = context;
        this.\u02ca = "";
        this.\u02ce = 0;
        AFKeystoreWrapper aFKeystoreWrapper = this;
        AFLogger.afInfoLog("Initialising KeyStore..");
        try {
            aFKeystoreWrapper.\u02cb = KeyStore.getInstance("AndroidKeyStore");
            aFKeystoreWrapper.\u02cb.load(null);
            return;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            AFLogger.afErrorLog("Couldn't load keystore instance of type: AndroidKeyStore", exception);
            return;
        }
    }

    final boolean \u02ce() {
        boolean bl = false;
        Object object = this.\u02cf;
        synchronized (object) {
            if (this.\u02cb != null) {
                try {
                    Enumeration<String> enumeration = this.\u02cb.aliases();
                    while (enumeration.hasMoreElements()) {
                        String string = enumeration.nextElement();
                        if (string == null || !string.startsWith("com.appsflyer")) continue;
                        String[] stringArray = string.split(",");
                        if (stringArray.length == 3) {
                            AFLogger.afInfoLog("Found a matching AF key with alias:\n".concat(String.valueOf(string)));
                            bl = true;
                            String[] stringArray2 = stringArray[1].trim().split("=");
                            String[] stringArray3 = stringArray[2].trim().split("=");
                            if (stringArray2.length == 2 && stringArray3.length == 2) {
                                this.\u02ca = stringArray2[1].trim();
                                this.\u02ce = Integer.parseInt(stringArray3[1].trim());
                            }
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    AFLogger.afErrorLog("Couldn't list KeyStore Aliases: " + throwable.getClass().getName(), throwable);
                }
            }
        }
        return bl;
    }

    final void \u02cf(String string) {
        AFLogger.afInfoLog("Creating a new key with alias: ".concat(String.valueOf(string)));
        try {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(1, 5);
            KeyGenParameterSpec keyGenParameterSpec = null;
            Object object = this.\u02cf;
            synchronized (object) {
                if (!this.\u02cb.containsAlias(string)) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        keyGenParameterSpec = new KeyGenParameterSpec.Builder(string, 3).setCertificateSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setCertificateSerialNumber(BigInteger.ONE).setCertificateNotBefore(calendar.getTime()).setCertificateNotAfter(calendar2.getTime()).build();
                    } else if (Build.VERSION.SDK_INT >= 18 && !"OPPO".equals(Build.BRAND)) {
                        keyGenParameterSpec = new KeyPairGeneratorSpec.Builder(this.\u0971).setAlias(string).setSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setSerialNumber(BigInteger.ONE).setStartDate(calendar.getTime()).setEndDate(calendar2.getTime()).build();
                    }
                    KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
                    keyPairGenerator.initialize((AlgorithmParameterSpec)keyGenParameterSpec);
                    ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
                } else {
                    AFLogger.afInfoLog("Alias already exists: ".concat(String.valueOf(string)));
                }
                return;
            }
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("Exception " + throwable.getMessage() + " occurred", throwable);
            return;
        }
    }

    final String \u02cf() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("com.appsflyer,");
        Object object = this.\u02cf;
        synchronized (object) {
            stringBuilder.append("KSAppsFlyerId=").append(this.\u02ca).append(",");
            stringBuilder.append("KSAppsFlyerRICounter=").append(this.\u02ce);
        }
        return ((Object)stringBuilder).toString();
    }

    final String \u0971() {
        Object object = this.\u02cf;
        synchronized (object) {
            return this.\u02ca;
        }
    }

    final int \u02cb() {
        Object object = this.\u02cf;
        synchronized (object) {
            return this.\u02ce;
        }
    }
}

