/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import org.jcodec.BitReader;
import org.jcodec.BitWriter;
import org.jcodec.CAVLCReader;
import org.jcodec.CAVLCWriter;

public class ScalingList {
    public int[] scalingList;
    public boolean useDefaultScalingMatrixFlag;

    public void write(BitWriter out) {
        if (this.useDefaultScalingMatrixFlag) {
            CAVLCWriter.writeSE(out, 0, "SPS: ");
            return;
        }
        int lastScale = 8;
        int nextScale = 8;
        for (int j2 = 0; j2 < this.scalingList.length; ++j2) {
            if (nextScale != 0) {
                int deltaScale = this.scalingList[j2] - lastScale - 256;
                CAVLCWriter.writeSE(out, deltaScale, "SPS: ");
            }
            lastScale = this.scalingList[j2];
        }
    }

    public static ScalingList read(BitReader in, int sizeOfScalingList) {
        ScalingList sl2 = new ScalingList();
        sl2.scalingList = new int[sizeOfScalingList];
        int lastScale = 8;
        int nextScale = 8;
        for (int j2 = 0; j2 < sizeOfScalingList; ++j2) {
            if (nextScale != 0) {
                int deltaScale = CAVLCReader.readSE(in, "deltaScale");
                nextScale = (lastScale + deltaScale + 256) % 256;
                sl2.useDefaultScalingMatrixFlag = j2 == 0 && nextScale == 0;
            }
            sl2.scalingList[j2] = nextScale == 0 ? lastScale : nextScale;
            lastScale = sl2.scalingList[j2];
        }
        return sl2;
    }
}

