/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import org.jcodec.FullBox;
import org.jcodec.Header;

public class SampleSizesBox
extends FullBox {
    private int defaultSize;
    private int count;
    private int[] sizes;

    public static String fourcc() {
        return "stsz";
    }

    public SampleSizesBox(int defaultSize, int count) {
        this();
        this.defaultSize = defaultSize;
        this.count = count;
    }

    public SampleSizesBox(int[] sizes) {
        this();
        this.sizes = sizes;
    }

    public SampleSizesBox() {
        super(new Header(SampleSizesBox.fourcc()));
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        this.defaultSize = input.getInt();
        this.count = input.getInt();
        if (this.defaultSize == 0) {
            this.sizes = new int[this.count];
            for (int i2 = 0; i2 < this.count; ++i2) {
                this.sizes[i2] = input.getInt();
            }
        }
    }

    public int getDefaultSize() {
        return this.defaultSize;
    }

    public int[] getSizes() {
        return this.sizes;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putInt(this.defaultSize);
        if (this.defaultSize == 0) {
            out.putInt(this.sizes.length);
            int[] nArray = this.sizes;
            int n2 = nArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                long size = nArray[i2];
                out.putInt((int)size);
            }
        } else {
            out.putInt(this.count);
        }
    }
}

