/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.jcodec.Box;
import org.jcodec.BoxFactory;
import org.jcodec.Header;
import org.jcodec.NodeBox;
import org.jcodec.SampleEntry;
import org.jcodec.TimecodeSampleEntry;
import org.jcodec.VideoSampleEntry;

public class SampleDescriptionBox
extends NodeBox {
    public static final MyFactory FACTORY = new MyFactory();

    public static String fourcc() {
        return "stsd";
    }

    public SampleDescriptionBox(Header header) {
        super(header);
        this.factory = FACTORY;
    }

    public SampleDescriptionBox() {
        this(new Header(SampleDescriptionBox.fourcc()));
    }

    public SampleDescriptionBox(SampleEntry ... entries) {
        this();
        for (SampleEntry e2 : entries) {
            this.boxes.add(e2);
        }
    }

    @Override
    public void parse(ByteBuffer input) {
        input.getInt();
        input.getInt();
        super.parse(input);
    }

    @Override
    public void doWrite(ByteBuffer out) {
        out.putInt(0);
        out.putInt(this.boxes.size());
        super.doWrite(out);
    }

    public static class MyFactory
    extends BoxFactory {
        private Map<String, Class<? extends Box>> handlers = new HashMap<String, Class<? extends Box>>();

        public MyFactory() {
            this.handlers.put("ap4h", VideoSampleEntry.class);
            this.handlers.put("apch", VideoSampleEntry.class);
            this.handlers.put("apcn", VideoSampleEntry.class);
            this.handlers.put("apcs", VideoSampleEntry.class);
            this.handlers.put("apco", VideoSampleEntry.class);
            this.handlers.put("avc1", VideoSampleEntry.class);
            this.handlers.put("cvid", VideoSampleEntry.class);
            this.handlers.put("jpeg", VideoSampleEntry.class);
            this.handlers.put("smc ", VideoSampleEntry.class);
            this.handlers.put("rle ", VideoSampleEntry.class);
            this.handlers.put("rpza", VideoSampleEntry.class);
            this.handlers.put("kpcd", VideoSampleEntry.class);
            this.handlers.put("png ", VideoSampleEntry.class);
            this.handlers.put("mjpa", VideoSampleEntry.class);
            this.handlers.put("mjpb", VideoSampleEntry.class);
            this.handlers.put("SVQ1", VideoSampleEntry.class);
            this.handlers.put("SVQ3", VideoSampleEntry.class);
            this.handlers.put("mp4v", VideoSampleEntry.class);
            this.handlers.put("dvc ", VideoSampleEntry.class);
            this.handlers.put("dvcp", VideoSampleEntry.class);
            this.handlers.put("gif ", VideoSampleEntry.class);
            this.handlers.put("h263", VideoSampleEntry.class);
            this.handlers.put("tiff", VideoSampleEntry.class);
            this.handlers.put("raw ", VideoSampleEntry.class);
            this.handlers.put("2vuY", VideoSampleEntry.class);
            this.handlers.put("yuv2", VideoSampleEntry.class);
            this.handlers.put("v308", VideoSampleEntry.class);
            this.handlers.put("v408", VideoSampleEntry.class);
            this.handlers.put("v216", VideoSampleEntry.class);
            this.handlers.put("v410", VideoSampleEntry.class);
            this.handlers.put("v210", VideoSampleEntry.class);
            this.handlers.put("m2v1", VideoSampleEntry.class);
            this.handlers.put("m1v1", VideoSampleEntry.class);
            this.handlers.put("xd5b", VideoSampleEntry.class);
            this.handlers.put("dv5n", VideoSampleEntry.class);
            this.handlers.put("jp2h", VideoSampleEntry.class);
            this.handlers.put("mjp2", VideoSampleEntry.class);
            this.handlers.put("tmcd", TimecodeSampleEntry.class);
            this.handlers.put("time", TimecodeSampleEntry.class);
            this.handlers.put("c608", SampleEntry.class);
            this.handlers.put("c708", SampleEntry.class);
            this.handlers.put("text", SampleEntry.class);
        }

        @Override
        public Class<? extends Box> toClass(String fourcc) {
            return this.handlers.get(fourcc);
        }
    }
}

