/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import org.jcodec.Box;
import org.jcodec.Header;
import org.jcodec.Rational;

public class PixelAspectExt
extends Box {
    private int hSpacing;
    private int vSpacing;

    public PixelAspectExt() {
        super(new Header(PixelAspectExt.fourcc()));
    }

    public PixelAspectExt(Rational par) {
        this();
        this.hSpacing = par.getNum();
        this.vSpacing = par.getDen();
    }

    @Override
    public void parse(ByteBuffer input) {
        this.hSpacing = input.getInt();
        this.vSpacing = input.getInt();
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        out.putInt(this.hSpacing);
        out.putInt(this.vSpacing);
    }

    public Rational getRational() {
        return new Rational(this.hSpacing, this.vSpacing);
    }

    public static String fourcc() {
        return "pasp";
    }
}

