/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import org.jcodec.TapeTimecode;

public class Packet {
    private ByteBuffer data;
    private long pts;
    private long timescale;
    private long duration;
    private long frameNo;
    private boolean keyFrame;
    private TapeTimecode tapeTimecode;
    private int displayOrder;

    public Packet(ByteBuffer data, long pts, long timescale, long duration, long frameNo, boolean keyFrame, TapeTimecode tapeTimecode) {
        this(data, pts, timescale, duration, frameNo, keyFrame, tapeTimecode, 0);
    }

    public Packet(Packet other) {
        this(other.data, other.pts, other.timescale, other.duration, other.frameNo, other.keyFrame, other.tapeTimecode);
        this.displayOrder = other.displayOrder;
    }

    public Packet(Packet other, ByteBuffer data) {
        this(data, other.pts, other.timescale, other.duration, other.frameNo, other.keyFrame, other.tapeTimecode);
        this.displayOrder = other.displayOrder;
    }

    public Packet(Packet other, TapeTimecode timecode) {
        this(other.data, other.pts, other.timescale, other.duration, other.frameNo, other.keyFrame, timecode);
        this.displayOrder = other.displayOrder;
    }

    public Packet(ByteBuffer data, long pts, long timescale, long duration, long frameNo, boolean keyFrame, TapeTimecode tapeTimecode, int displayOrder) {
        this.data = data;
        this.pts = pts;
        this.timescale = timescale;
        this.duration = duration;
        this.frameNo = frameNo;
        this.keyFrame = keyFrame;
        this.tapeTimecode = tapeTimecode;
        this.displayOrder = displayOrder;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public long getPts() {
        return this.pts;
    }

    public long getDuration() {
        return this.duration;
    }

    public TapeTimecode getTapeTimecode() {
        return this.tapeTimecode;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public boolean isKeyFrame() {
        return this.keyFrame;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }
}

