/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import org.jcodec.Box;
import org.jcodec.Header;
import org.jcodec.JCodecUtil;
import org.jcodec.NIOUtils;

public class NameBox
extends Box {
    private String name;

    public static String fourcc() {
        return "name";
    }

    public NameBox(String name) {
        this();
        this.name = name;
    }

    public NameBox() {
        super(new Header(NameBox.fourcc()));
    }

    @Override
    public void parse(ByteBuffer input) {
        this.name = NIOUtils.readNullTermString(input);
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        out.put(JCodecUtil.asciiString(this.name));
        out.putInt(0);
    }

    public String getName() {
        return this.name;
    }
}

