/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import android.annotation.SuppressLint;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.jcodec.FileChannelWrapper;
import org.jcodec.JCodecUtil;

public class NIOUtils {
    public static final ByteBuffer read(ByteBuffer buffer, int count) {
        ByteBuffer slice = buffer.duplicate();
        int limit = buffer.position() + count;
        slice.limit(limit);
        buffer.position(limit);
        return slice;
    }

    public static byte[] toArray(ByteBuffer buffer) {
        byte[] result = new byte[buffer.remaining()];
        buffer.duplicate().get(result);
        return result;
    }

    public static byte[] toArray(ByteBuffer buffer, int count) {
        byte[] result = new byte[Math.min(buffer.remaining(), count)];
        buffer.duplicate().get(result);
        return result;
    }

    public static int read(ReadableByteChannel channel, ByteBuffer buffer, int length) throws IOException {
        ByteBuffer fork = buffer.duplicate();
        fork.limit(Math.min(fork.position() + length, fork.limit()));
        while (channel.read(fork) != -1 && fork.hasRemaining()) {
        }
        int read = fork.position() - buffer.position();
        buffer.position(fork.position());
        return read;
    }

    public static int read(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        int rem = buffer.position();
        while (channel.read(buffer) != -1 && buffer.hasRemaining()) {
        }
        return buffer.position() - rem;
    }

    public static void write(ByteBuffer to, ByteBuffer from) {
        if (from.hasArray()) {
            to.put(from.array(), from.arrayOffset() + from.position(), Math.min(to.remaining(), from.remaining()));
        } else {
            to.put(NIOUtils.toArray(from, to.remaining()));
        }
    }

    public static void write(ByteBuffer to, ByteBuffer from, int count) {
        if (from.hasArray()) {
            to.put(from.array(), from.arrayOffset() + from.position(), Math.min(from.remaining(), count));
        } else {
            to.put(NIOUtils.toArray(from, count));
        }
    }

    public static final MappedByteBuffer map(String fileName) throws IOException {
        return NIOUtils.map(new File(fileName));
    }

    public static final MappedByteBuffer map(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        MappedByteBuffer map = is.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        is.close();
        return map;
    }

    public static int skip(ByteBuffer buffer, int count) {
        int toSkip = Math.min(buffer.remaining(), count);
        buffer.position(buffer.position() + toSkip);
        return toSkip;
    }

    public static ByteBuffer from(ByteBuffer buffer, int offset) {
        ByteBuffer dup = buffer.duplicate();
        dup.position(dup.position() + offset);
        return dup;
    }

    public static String readString(ByteBuffer buffer, int len) {
        return new String(NIOUtils.toArray(NIOUtils.read(buffer, len)));
    }

    public static String readPascalString(ByteBuffer buffer, int maxLen) {
        ByteBuffer sub = NIOUtils.read(buffer, maxLen + 1);
        return new String(NIOUtils.toArray(NIOUtils.read(sub, Math.min(sub.get() & 0xFF, maxLen))));
    }

    public static void writePascalString(ByteBuffer buffer, String string, int maxLen) {
        buffer.put((byte)string.length());
        buffer.put(JCodecUtil.asciiString(string));
        NIOUtils.skip(buffer, maxLen - string.length());
    }

    public static void writePascalString(ByteBuffer buffer, String name) {
        buffer.put((byte)name.length());
        buffer.put(JCodecUtil.asciiString(name));
    }

    public static String readPascalString(ByteBuffer buffer) {
        return NIOUtils.readString(buffer, buffer.get() & 0xFF);
    }

    public static String readNullTermString(ByteBuffer buffer) {
        return NIOUtils.readNullTermString(buffer, Charset.defaultCharset());
    }

    @SuppressLint(value={"NewApi"})
    public static String readNullTermString(ByteBuffer buffer, Charset charset) {
        ByteBuffer fork = buffer.duplicate();
        while (buffer.hasRemaining() && buffer.get() != 0) {
        }
        if (buffer.hasRemaining()) {
            fork.limit(buffer.position() - 1);
        }
        return new String(NIOUtils.toArray(fork), charset);
    }

    public static ByteBuffer read(ByteBuffer buffer) {
        ByteBuffer result = buffer.duplicate();
        buffer.position(buffer.limit());
        return result;
    }

    public static void copy(ReadableByteChannel in, WritableByteChannel out, long amount) throws IOException {
        int read;
        ByteBuffer buf = ByteBuffer.allocate(65536);
        do {
            buf.position(0);
            buf.limit((int)Math.min(amount, (long)buf.capacity()));
            read = in.read(buf);
            if (read == -1) continue;
            buf.flip();
            out.write(buf);
            amount -= (long)read;
        } while (read != -1 && amount > 0L);
    }

    public static void writeLong(WritableByteChannel channel, long value) throws IOException {
        channel.write((ByteBuffer)ByteBuffer.allocate(8).putLong(value).flip());
    }

    public static FileChannelWrapper writableFileChannel(File file) throws FileNotFoundException {
        return new FileChannelWrapper(new FileOutputStream(file).getChannel(), file.getAbsolutePath(), 0L);
    }

    public static FileChannelWrapper writableFileChannel(String file, long wantedSize) throws FileNotFoundException {
        return new FileChannelWrapper(new FileOutputStream(file).getChannel(), file, wantedSize);
    }

    public static ByteBuffer duplicate(ByteBuffer bb2) {
        ByteBuffer out = ByteBuffer.allocate(bb2.remaining());
        out.put(bb2.duplicate());
        out.flip();
        return out;
    }

    public static int find(List<ByteBuffer> catalog, ByteBuffer key) {
        byte[] keyA = NIOUtils.toArray(key);
        for (int i2 = 0; i2 < catalog.size(); ++i2) {
            if (!Arrays.equals(NIOUtils.toArray(catalog.get(i2)), keyA)) continue;
            return i2;
        }
        return -1;
    }
}

