/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import org.jcodec.FullBox;
import org.jcodec.Header;
import org.jcodec.NIOUtils;
import org.jcodec.TimeUtil;
import org.jcodec.ToJSON;

public class MovieHeaderBox
extends FullBox {
    private int timescale;
    private long duration;
    private float rate;
    private float volume;
    private long created;
    private long modified;
    private int[] matrix;
    private int nextTrackId;

    public static String fourcc() {
        return "mvhd";
    }

    public MovieHeaderBox(int timescale, long duration, float rate, float volume, long created, long modified, int[] matrix, int nextTrackId) {
        super(new Header(MovieHeaderBox.fourcc()));
        this.timescale = timescale;
        this.duration = duration;
        this.rate = rate;
        this.volume = volume;
        this.created = created;
        this.modified = modified;
        this.matrix = matrix;
        this.nextTrackId = nextTrackId;
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        if (this.version == 0) {
            this.created = TimeUtil.fromMovTime(input.getInt());
            this.modified = TimeUtil.fromMovTime(input.getInt());
            this.timescale = input.getInt();
            this.duration = input.getInt();
        } else if (this.version == 1) {
            this.created = TimeUtil.fromMovTime((int)input.getLong());
            this.modified = TimeUtil.fromMovTime((int)input.getLong());
            this.timescale = input.getInt();
            this.duration = input.getLong();
        } else {
            throw new RuntimeException("Unsupported version");
        }
        this.rate = this.readRate(input);
        this.volume = this.readVolume(input);
        NIOUtils.skip(input, 10);
        this.matrix = this.readMatrix(input);
        NIOUtils.skip(input, 24);
        this.nextTrackId = input.getInt();
    }

    private int[] readMatrix(ByteBuffer input) {
        int[] matrix = new int[9];
        for (int i2 = 0; i2 < 9; ++i2) {
            matrix[i2] = input.getInt();
        }
        return matrix;
    }

    private float readVolume(ByteBuffer input) {
        return (float)input.getShort() / 256.0f;
    }

    private float readRate(ByteBuffer input) {
        return (float)input.getInt() / 65536.0f;
    }

    @Override
    public void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putInt(TimeUtil.toMovTime(this.created));
        out.putInt(TimeUtil.toMovTime(this.modified));
        out.putInt(this.timescale);
        out.putInt((int)this.duration);
        this.writeFixed1616(out, this.rate);
        this.writeFixed88(out, this.volume);
        out.put(new byte[10]);
        this.writeMatrix(out);
        out.put(new byte[24]);
        out.putInt(this.nextTrackId);
    }

    private void writeMatrix(ByteBuffer out) {
        int i2;
        for (i2 = 0; i2 < Math.min(9, this.matrix.length); ++i2) {
            out.putInt(this.matrix[i2]);
        }
        for (i2 = Math.min(9, this.matrix.length); i2 < 9; ++i2) {
            out.putInt(0);
        }
    }

    private void writeFixed88(ByteBuffer out, float volume) {
        out.putShort((short)((double)volume * 256.0));
    }

    private void writeFixed1616(ByteBuffer out, float rate) {
        out.putInt((int)((double)rate * 65536.0));
    }

    public int getTimescale() {
        return this.timescale;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setTimescale(int newTs) {
        this.timescale = newTs;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public int getNextTrackId() {
        return this.nextTrackId;
    }

    public void setNextTrackId(int nextTrackId) {
        this.nextTrackId = nextTrackId;
    }

    @Override
    protected void dump(StringBuilder sb2) {
        super.dump(sb2);
        sb2.append(": ");
        ToJSON.toJSON(this, sb2, "timescale", "duration", "rate", "volume", "created", "modified", "nextTrackId");
    }
}

