/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.jcodec.Codec;
import org.jcodec.MovieBox;
import org.jcodec.SeekableByteChannel;

public class MP4Util {
    private static final int MIN_HEADER_SIZE = 256000;
    private static Map<Codec, String> codecMapping = new HashMap<Codec, String>();

    public static void writeMovieOnFile(SeekableByteChannel out, MovieBox movie) throws IOException {
        long lastPos = out.position();
        out.close();
        RandomAccessFile raf = new RandomAccessFile(out.getFileName(), "rws");
        raf.setLength(Math.max(out.getWantedSize() * 2L, 256000L));
        MappedByteBuffer buf = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, raf.length());
        buf.position((int)lastPos);
        movie.write(buf);
        int writePos = buf.position();
        FileChannel rafCh = raf.getChannel();
        rafCh.truncate(writePos);
        out.setChannel(rafCh);
    }

    public static String getFourcc(Codec codec) {
        return codecMapping.get((Object)codec);
    }

    static {
        codecMapping.put(Codec.MPEG2, "m2v1");
        codecMapping.put(Codec.H264, "avc1");
        codecMapping.put(Codec.J2K, "mjp2");
    }
}

