/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jcodec.AbstractMP4MuxerTrack;
import org.jcodec.Box;
import org.jcodec.Brand;
import org.jcodec.FileTypeBox;
import org.jcodec.FramesMP4MuxerTrack;
import org.jcodec.Header;
import org.jcodec.MP4Util;
import org.jcodec.MovieBox;
import org.jcodec.MovieHeaderBox;
import org.jcodec.NIOUtils;
import org.jcodec.NodeBox;
import org.jcodec.SeekableByteChannel;
import org.jcodec.Size;
import org.jcodec.TrackType;
import org.jcodec.VideoSampleEntry;

public class MP4Muxer {
    private List<AbstractMP4MuxerTrack> tracks = new ArrayList<AbstractMP4MuxerTrack>();
    private long mdatOffset;
    private int nextTrackId = 1;
    SeekableByteChannel out;

    public MP4Muxer(SeekableByteChannel output, Brand brand) throws IOException {
        this(output, brand.getFileTypeBox());
    }

    public MP4Muxer(SeekableByteChannel output, FileTypeBox ftyp) throws IOException {
        this.out = output;
        ByteBuffer buf = ByteBuffer.allocate(1024);
        ftyp.write(buf);
        new Header("wide", 8L).write(buf);
        new Header("mdat", 1L).write(buf);
        this.mdatOffset = buf.position();
        buf.putLong(0L);
        buf.flip();
        output.write(buf);
    }

    public static VideoSampleEntry videoSampleEntry(String fourcc, Size size, String encoderName) {
        return new VideoSampleEntry(new Header(fourcc), 0, 0, "jcod", 0, 768, (short)size.getWidth(), (short)size.getHeight(), 72L, 72L, 1, encoderName != null ? encoderName : "jcodec", 24, 1, -1);
    }

    public FramesMP4MuxerTrack addTrackForCompressed(TrackType type, int timescale) {
        FramesMP4MuxerTrack track = new FramesMP4MuxerTrack(this.out, this.nextTrackId++, type, timescale);
        this.tracks.add(track);
        return track;
    }

    public List<AbstractMP4MuxerTrack> getTracks() {
        return this.tracks;
    }

    public void writeHeader() throws IOException {
        MovieBox movie = this.finalizeHeader();
        this.storeHeader(movie);
    }

    public void storeHeader(MovieBox movie) throws IOException {
        long mdatSize = this.out.position() - this.mdatOffset + 8L;
        MP4Util.writeMovieOnFile(this.out, movie);
        this.out.position(this.mdatOffset);
        NIOUtils.writeLong(this.out, mdatSize);
    }

    public MovieBox finalizeHeader() throws IOException {
        MovieBox movie = new MovieBox();
        MovieHeaderBox mvhd = this.movieHeader(movie);
        movie.addFirst(mvhd);
        for (AbstractMP4MuxerTrack track : this.tracks) {
            Box trak = track.finish(mvhd);
            if (trak == null) continue;
            movie.add(trak);
        }
        return movie;
    }

    public AbstractMP4MuxerTrack getVideoTrack() {
        for (AbstractMP4MuxerTrack frameMuxer : this.tracks) {
            if (!frameMuxer.isVideo()) continue;
            return frameMuxer;
        }
        return null;
    }

    private MovieHeaderBox movieHeader(NodeBox movie) {
        int timescale = this.tracks.get(0).getTimescale();
        long duration = this.tracks.get(0).getTrackTotalDuration();
        AbstractMP4MuxerTrack videoTrack = this.getVideoTrack();
        if (videoTrack != null) {
            timescale = videoTrack.getTimescale();
            duration = videoTrack.getTrackTotalDuration();
        }
        return new MovieHeaderBox(timescale, duration, 1.0f, 1.0f, new Date().getTime(), new Date().getTime(), new int[]{65536, 0, 0, 0, 65536, 0, 0, 0, 0x40000000}, this.nextTrackId);
    }
}

