/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

public class LongArrayList {
    private static final int DEFAULT_GROW_AMOUNT = 128;
    private long[] storage;
    private int size;
    private int growAmount;

    public LongArrayList() {
        this(128);
    }

    public LongArrayList(int growAmount) {
        this.growAmount = growAmount;
        this.storage = new long[growAmount];
    }

    public long[] toArray() {
        long[] result = new long[this.size];
        System.arraycopy(this.storage, 0, result, 0, this.size);
        return result;
    }

    public void add(long val) {
        if (this.size >= this.storage.length) {
            long[] ns = new long[this.storage.length + this.growAmount];
            System.arraycopy(this.storage, 0, ns, 0, this.storage.length);
            this.storage = ns;
        }
        this.storage[this.size++] = val;
    }

    public void set(int index, int value) {
        this.storage[index] = value;
    }

    public long get(int index) {
        return this.storage[index];
    }

    public int size() {
        return this.size;
    }
}

