/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import org.jcodec.Box;
import org.jcodec.Header;

public class GamaExtension
extends Box {
    private float gamma;

    public GamaExtension(float gamma) {
        super(new Header(GamaExtension.fourcc(), 0L));
        this.gamma = gamma;
    }

    public GamaExtension(Header header) {
        super(header);
    }

    public GamaExtension(Box other) {
        super(other);
    }

    @Override
    public void parse(ByteBuffer input) {
        float g2 = input.getInt();
        this.gamma = g2 / 65536.0f;
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        out.putInt((int)(this.gamma * 65536.0f));
    }

    public float getGamma() {
        return this.gamma;
    }

    public static String fourcc() {
        return "gama";
    }
}

