/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import org.jcodec.Box;
import org.jcodec.Header;
import org.jcodec.JCodecUtil;
import org.jcodec.NIOUtils;

public class FileTypeBox
extends Box {
    private String majorBrand;
    private int minorVersion;
    private Collection<String> compBrands = new LinkedList<String>();

    public static String fourcc() {
        return "ftyp";
    }

    public FileTypeBox(String majorBrand, int minorVersion, Collection<String> compBrands) {
        super(new Header(FileTypeBox.fourcc()));
        this.majorBrand = majorBrand;
        this.minorVersion = minorVersion;
        this.compBrands = compBrands;
    }

    @Override
    public void parse(ByteBuffer input) {
        String brand;
        this.majorBrand = NIOUtils.readString(input, 4);
        this.minorVersion = input.getInt();
        while ((brand = NIOUtils.readString(input, 4)) != null) {
            this.compBrands.add(brand);
        }
    }

    @Override
    public void doWrite(ByteBuffer out) {
        out.put(JCodecUtil.asciiString(this.majorBrand));
        out.putInt(this.minorVersion);
        for (String string : this.compBrands) {
            out.put(JCodecUtil.asciiString(string));
        }
    }
}

