/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import org.jcodec.Box;
import org.jcodec.Header;

public class FielExtension
extends Box {
    private int type;
    private int order;

    public FielExtension(byte type, byte order) {
        super(new Header(FielExtension.fourcc()));
        this.type = type;
        this.order = order;
    }

    public static String fourcc() {
        return "fiel";
    }

    public boolean isInterlaced() {
        return this.type == 2;
    }

    @Override
    public void parse(ByteBuffer input) {
        this.type = input.get() & 0xFF;
        if (this.isInterlaced()) {
            this.order = input.get() & 0xFF;
        }
    }

    @Override
    public void doWrite(ByteBuffer out) {
        out.put((byte)this.type);
        out.put((byte)this.order);
    }
}

