/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import org.jcodec.Box;
import org.jcodec.Header;
import org.jcodec.JCodecUtil;

public class ColorExtension
extends Box {
    private short primariesIndex;
    private short transferFunctionIndex;
    private short matrixIndex;
    private final String type = "nclc";

    public ColorExtension(short primariesIndex, short transferFunctionIndex, short matrixIndex) {
        this();
        this.primariesIndex = primariesIndex;
        this.transferFunctionIndex = transferFunctionIndex;
        this.matrixIndex = matrixIndex;
    }

    public ColorExtension() {
        super(new Header(ColorExtension.fourcc()));
    }

    @Override
    public void parse(ByteBuffer input) {
        long type = input.getInt();
        this.primariesIndex = input.getShort();
        this.transferFunctionIndex = input.getShort();
        this.matrixIndex = input.getShort();
    }

    @Override
    public void doWrite(ByteBuffer out) {
        out.put(JCodecUtil.asciiString("nclc"));
        out.putShort(this.primariesIndex);
        out.putShort(this.transferFunctionIndex);
        out.putShort(this.matrixIndex);
    }

    public static String fourcc() {
        return "colr";
    }
}

