/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import org.jcodec.FullBox;
import org.jcodec.Header;

public class ChunkOffsets64Box
extends FullBox {
    private long[] chunkOffsets;

    public static String fourcc() {
        return "co64";
    }

    public ChunkOffsets64Box(Header atom) {
        super(atom);
    }

    public ChunkOffsets64Box() {
        super(new Header(ChunkOffsets64Box.fourcc(), 0L));
    }

    public ChunkOffsets64Box(long[] offsets) {
        this();
        this.chunkOffsets = offsets;
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        int length = input.getInt();
        this.chunkOffsets = new long[length];
        for (int i2 = 0; i2 < length; ++i2) {
            this.chunkOffsets[i2] = input.getLong();
        }
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putInt(this.chunkOffsets.length);
        for (long offset : this.chunkOffsets) {
            out.putLong(offset);
        }
    }

    public long[] getChunkOffsets() {
        return this.chunkOffsets;
    }

    public void setChunkOffsets(long[] chunkOffsets) {
        this.chunkOffsets = chunkOffsets;
    }
}

