/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import org.jcodec.FullBox;
import org.jcodec.Header;

public class ChannelBox
extends FullBox {
    private int channelLayout;
    private int channelBitmap;
    private ChannelDescription[] descriptions;

    public ChannelBox() {
        super(new Header(ChannelBox.fourcc()));
    }

    public static String fourcc() {
        return "chan";
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        this.channelLayout = input.getInt();
        this.channelBitmap = input.getInt();
        int numDescriptions = input.getInt();
        this.descriptions = new ChannelDescription[numDescriptions];
        for (int i2 = 0; i2 < numDescriptions; ++i2) {
            this.descriptions[i2] = new ChannelDescription(input.getInt(), input.getInt(), new float[]{Float.intBitsToFloat(input.getInt()), Float.intBitsToFloat(input.getInt()), Float.intBitsToFloat(input.getInt())});
        }
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putInt(this.channelLayout);
        out.putInt(this.channelBitmap);
        out.putInt(this.descriptions.length);
        for (ChannelDescription channelDescription : this.descriptions) {
            out.putInt(channelDescription.getChannelLabel());
            out.putInt(channelDescription.getChannelFlags());
            out.putFloat(channelDescription.getCoordinates()[0]);
            out.putFloat(channelDescription.getCoordinates()[1]);
            out.putFloat(channelDescription.getCoordinates()[2]);
        }
    }

    public static class ChannelDescription {
        private int channelLabel;
        private int channelFlags;
        private float[] coordinates = new float[3];

        public ChannelDescription(int channelLabel, int channelFlags, float[] coordinates) {
            this.channelLabel = channelLabel;
            this.channelFlags = channelFlags;
            this.coordinates = coordinates;
        }

        public int getChannelLabel() {
            return this.channelLabel;
        }

        public int getChannelFlags() {
            return this.channelFlags;
        }

        public float[] getCoordinates() {
            return this.coordinates;
        }
    }
}

