/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.AvcCBox;
import org.jcodec.Brand;
import org.jcodec.FileChannelWrapper;
import org.jcodec.FramesMP4MuxerTrack;
import org.jcodec.H264Utils;
import org.jcodec.MP4Muxer;
import org.jcodec.MP4Packet;
import org.jcodec.MappedH264ES;
import org.jcodec.NIOUtils;
import org.jcodec.Packet;
import org.jcodec.PictureParameterSet;
import org.jcodec.SeekableByteChannel;
import org.jcodec.SeqParameterSet;
import org.jcodec.Size;
import org.jcodec.TrackType;
import org.jcodec.VideoSampleEntry;

public class AVCMP4Mux {
    private static AvcCBox avcC;

    public void muxH264File(File h264File, String outputVideoFile, List<Long> frameTimes) throws Exception {
        FileChannelWrapper outFile = NIOUtils.writableFileChannel(outputVideoFile, h264File.length());
        MP4Muxer muxer = new MP4Muxer((SeekableByteChannel)outFile, Brand.MP4);
        FramesMP4MuxerTrack track = muxer.addTrackForCompressed(TrackType.VIDEO, 1000000);
        AVCMP4Mux.mux(track, h264File, frameTimes);
        muxer.writeHeader();
        outFile.close();
    }

    private static final MappedByteBuffer mapFile(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        MappedByteBuffer map = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, file.length());
        raf.close();
        return map;
    }

    private static void mux(FramesMP4MuxerTrack track, File h264File, List<Long> frameTimes) throws IOException {
        MappedH264ES es = new MappedH264ES(AVCMP4Mux.mapFile(h264File));
        ArrayList<ByteBuffer> spsList = new ArrayList<ByteBuffer>();
        ArrayList<ByteBuffer> ppsList = new ArrayList<ByteBuffer>();
        Packet frame = null;
        int frameNo = 0;
        while ((frame = es.nextFrame()) != null) {
            ByteBuffer data = frame.getData();
            H264Utils.wipePS(data, spsList, ppsList);
            H264Utils.encodeMOVPacket(data);
            long frameTime = frameTimes.get(frameNo);
            long frameDur = frameTimes.size() - 1 > frameNo ? frameTimes.get(frameNo + 1) - frameTime : 250000L;
            track.addFrame(new MP4Packet(data, frameTime, 1000000L, frameDur, frameNo, true, null, frameTime, 0));
            ++frameNo;
        }
        AVCMP4Mux.addSampleEntry(track, es.getSps(), es.getPps());
    }

    private static void addSampleEntry(FramesMP4MuxerTrack track, SeqParameterSet[] spss, PictureParameterSet[] ppss) {
        SeqParameterSet sps = spss[0];
        Size size = new Size(sps.pic_width_in_mbs_minus1 + 1 << 4, H264Utils.getPicHeightInMbs(sps) << 4);
        VideoSampleEntry se = MP4Muxer.videoSampleEntry("avc1", size, "JCodec");
        avcC = new AvcCBox(sps.profile_idc, 0, sps.level_idc, AVCMP4Mux.write(spss), AVCMP4Mux.write(ppss));
        se.add(avcC);
        track.addSampleEntry(se);
    }

    private static List<ByteBuffer> write(PictureParameterSet[] ppss) {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        for (PictureParameterSet pps : ppss) {
            ByteBuffer buf = ByteBuffer.allocate(1024);
            pps.write(buf);
            buf.flip();
            result.add(buf);
        }
        return result;
    }

    private static List<ByteBuffer> write(SeqParameterSet[] spss) {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        for (SeqParameterSet sps : spss) {
            ByteBuffer buf = ByteBuffer.allocate(1024);
            sps.write(buf);
            buf.flip();
            result.add(buf);
        }
        return result;
    }
}

