/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.util;

import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import com.tracelytics.util.BackTraceCache;
import java.util.Arrays;
import java.util.List;

public class BackTraceUtil {
    private static final Logger a = LoggerFactory.getLogger();

    public static StackTraceElement[] getBackTrace(int n2) {
        int n3 = n2 + 2;
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (n3 >= stackTraceElementArray.length) {
            a.debug("Attempt to skip [" + n2 + "] elements in addBackTrace is invalid, no stack trace element is left!");
            return new StackTraceElement[0];
        }
        n2 = stackTraceElementArray.length - n3;
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[n2];
        System.arraycopy(stackTraceElementArray, n3, stackTraceElementArray2, 0, n2);
        return stackTraceElementArray2;
    }

    public static String backTraceToString(StackTraceElement[] stackTraceElementArray) {
        List<StackTraceElement> list = Arrays.asList(stackTraceElementArray);
        CharSequence charSequence = BackTraceCache.a(list);
        if (charSequence != null) {
            return charSequence;
        }
        charSequence = new StringBuffer();
        if (stackTraceElementArray.length > 120) {
            BackTraceUtil.a(stackTraceElementArray, 0, 100, (StringBuffer)charSequence);
            ((StringBuffer)charSequence).append("...Skipped " + (stackTraceElementArray.length - 120) + " line(s)\n");
            BackTraceUtil.a(stackTraceElementArray, stackTraceElementArray.length - 20, 20, (StringBuffer)charSequence);
        } else {
            BackTraceUtil.a(stackTraceElementArray, 0, stackTraceElementArray.length, (StringBuffer)charSequence);
        }
        stackTraceElementArray = ((StringBuffer)charSequence).toString();
        BackTraceCache.a(list, (String)stackTraceElementArray);
        return stackTraceElementArray;
    }

    private static void a(StackTraceElement[] stackTraceElementArray, int n2, int n3, StringBuffer stringBuffer) {
        for (int i2 = n2; i2 < n2 + n3 && i2 < stackTraceElementArray.length; ++i2) {
            stringBuffer.append(stackTraceElementArray[i2].toString());
            stringBuffer.append("\n");
        }
    }
}

