/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe.settings;

import com.tracelytics.joboe.rpc.Client;
import com.tracelytics.joboe.rpc.ClientLoggingCallback;
import com.tracelytics.joboe.rpc.ResultCode;
import com.tracelytics.joboe.rpc.SettingsResult;
import com.tracelytics.joboe.settings.OboeSettingsException;
import com.tracelytics.joboe.settings.Settings;
import com.tracelytics.joboe.settings.b;
import com.tracelytics.logging.LoggerFactory;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpcSettingsReader
implements b {
    private Client a;
    private ClientLoggingCallback<SettingsResult> b = new ClientLoggingCallback("get service settings");

    RpcSettingsReader(Client client) {
        this.a = client;
    }

    @Override
    public Map<String, Settings> getSettings() throws OboeSettingsException {
        SettingsResult settingsResult;
        try {
            settingsResult = this.a.getSettings("2", this.b).get();
        }
        catch (Exception exception) {
            throw new OboeSettingsException("Exception from RPC call: " + exception.getMessage(), exception);
        }
        if (settingsResult.getResultCode() == ResultCode.OK) {
            LinkedHashMap<String, Settings> linkedHashMap = new LinkedHashMap<String, Settings>();
            for (Settings settings : settingsResult.getSettings()) {
                linkedHashMap.put(settings.getLayer(), settings);
            }
            return linkedHashMap;
        }
        throw new OboeSettingsException("Rpc call returns non OK status code: " + (Object)((Object)settingsResult.getResultCode()));
    }

    @Override
    public void close() {
        if (this.a != null) {
            this.a.close();
        }
    }

    static {
        LoggerFactory.getLogger();
    }
}

