/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe;

import com.tracelytics.agent.Agent;
import com.tracelytics.c.a;
import com.tracelytics.joboe.EventImpl;
import com.tracelytics.joboe.ReporterFactory;
import com.tracelytics.joboe.RpcEventReporter;
import com.tracelytics.joboe.ShutdownManager;
import com.tracelytics.joboe.TestReporter;
import com.tracelytics.joboe.TestingEnv;
import com.tracelytics.joboe.config.ConfigManager;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.config.ProfilerSetting;
import com.tracelytics.joboe.rpc.ClientException;
import com.tracelytics.joboe.rpc.RpcClientManager;
import com.tracelytics.joboe.settings.SettingsManager;
import com.tracelytics.joboe.settings.SimpleSettingsFetcher;
import com.tracelytics.joboe.settings.TestSettingsReader;
import com.tracelytics.joboe.span.impl.ProfilingSpanReporter;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import com.tracelytics.monitor.c;
import com.tracelytics.monitor.metrics.CustomMetricsCollector;
import com.tracelytics.util.BackTraceCache;
import com.tracelytics.util.DaemonThreadFactory;
import com.tracelytics.util.HostInfoUtils;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartupManager {
    private static boolean a = false;
    private static final Logger b = LoggerFactory.getLogger();
    private static Future<?> c;
    private static boolean d;
    private static ScheduledExecutorService e;

    public static boolean isStartupCompleted() {
        return a;
    }

    public static synchronized void flagSystemStartupCompleted() {
        StartupManager.flagSystemStartupCompleted(null);
    }

    public static synchronized void flagSystemStartupCompleted(Long l2) {
        if (Agent.getStatus() == Agent.AgentStatus.DISABLED) {
            return;
        }
        if (!a) {
            if (!d) {
                ExecutorService executorService = Executors.newSingleThreadExecutor(DaemonThreadFactory.newInstance("post-startup-tasks"));
                Future<?> future = executorService.submit(new Runnable(){

                    public final void run() {
                        try {
                            Object object;
                            Agent.checkRetransformation();
                            Agent.reportInit();
                            CountDownLatch countDownLatch = null;
                            try {
                                object = HostInfoUtils.getNetworkAddressInfo();
                                object = object != null ? ((HostInfoUtils.NetworkAddressInfo)object).getIpAddresses() : Collections.emptyList();
                                b.debug("Detected host id: " + HostInfoUtils.getHostId() + " ip addresses: " + object);
                                countDownLatch = SettingsManager.initialize();
                            }
                            catch (ClientException clientException) {
                                b.warn("Failed to initialize RpcSettingsReader : " + clientException.getMessage());
                            }
                            EventImpl.setDefaultReporter(RpcEventReporter.buildReporter(RpcClientManager.OperationType.TRACING));
                            com.tracelytics.monitor.c.b();
                            BackTraceCache.enable();
                            object = (ProfilerSetting)ConfigManager.getConfig(ConfigProperty.PROFILER);
                            if (object != null && ((ProfilerSetting)object).isEnabled()) {
                                b.debug("Profiler is enabled, local settings : " + object);
                                com.tracelytics.c.a.a((ProfilerSetting)object, RpcEventReporter.buildReporter(RpcClientManager.OperationType.PROFILING));
                                if (e == null) {
                                    e = Executors.newScheduledThreadPool(1, DaemonThreadFactory.newInstance("profileCounterReporter"));
                                }
                                StartupManager.b(e);
                            } else {
                                b.debug("Profiler is disabled, local settings : " + object);
                            }
                            try {
                                if (countDownLatch != null) {
                                    countDownLatch.await();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                b.warn("Failed to wait for settings from RpcSettingsReader : " + interruptedException.getMessage());
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            b.warn("Failed post system startup operations due to : " + throwable.getMessage(), throwable);
                        }
                    }
                });
                executorService.shutdown();
                c = future;
            } else {
                ExecutorService executorService = Executors.newSingleThreadExecutor(DaemonThreadFactory.newInstance("post-startup-tasks"));
                Future<TestingEnv> future = executorService.submit(new Callable<TestingEnv>(){

                    private static TestingEnv a() {
                        TestSettingsReader testSettingsReader = new TestSettingsReader();
                        SettingsManager.initializeFetcher(new SimpleSettingsFetcher(testSettingsReader));
                        try {
                            TestReporter testReporter = ReporterFactory.getInstance().buildTestReporter();
                            EventImpl.setDefaultReporter(testReporter);
                            TestReporter testReporter2 = ReporterFactory.getInstance().buildTestReporter();
                            ProfilerSetting profilerSetting = (ProfilerSetting)ConfigManager.getConfig(ConfigProperty.PROFILER);
                            if (profilerSetting != null && profilerSetting.isEnabled()) {
                                b.debug("Profiler is enabled, local settings : " + profilerSetting);
                                com.tracelytics.c.a.a(profilerSetting, testReporter2);
                            } else {
                                com.tracelytics.c.a.a(new ProfilerSetting(true, 20), testReporter2);
                            }
                            return new TestingEnv(testReporter, testReporter2, testSettingsReader);
                        }
                        catch (Exception exception) {
                            Exception exception2 = exception;
                            exception.printStackTrace();
                            return null;
                        }
                    }

                    @Override
                    public final /* synthetic */ Object call() throws Exception {
                        return 3.a();
                    }
                });
                executorService.shutdown();
                c = future;
            }
            ShutdownManager.a();
        }
        if (l2 != null) {
            try {
                c.get(l2, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                b.warn("Failed to block on flagSystemStartupCompleted : " + interruptedException.getMessage(), interruptedException);
            }
            catch (ExecutionException executionException) {
                b.warn("Failed to block on flagSystemStartupCompleted : " + executionException.getMessage(), executionException);
            }
            catch (TimeoutException timeoutException) {
                b.warn("Waited for [" + l2 + "] milliseconds but the post startup operations are still not completed");
            }
        }
        a = true;
    }

    public static void flagTestingMode() {
        d = true;
    }

    public static Future<?> isAgentReady() {
        StartupManager.flagSystemStartupCompleted();
        return c;
    }

    static /* synthetic */ void b(ScheduledExecutorService scheduledExecutorService) {
        scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            public final void run() {
                try {
                    long l2 = com.tracelytics.c.a.b.get();
                    long l3 = com.tracelytics.c.a.d.get();
                    long l4 = com.tracelytics.c.a.c.get();
                    long l5 = com.tracelytics.c.a.e.get();
                    long l6 = com.tracelytics.c.a.f.get();
                    long l7 = com.tracelytics.c.a.g.get();
                    long l8 = com.tracelytics.c.a.h.get();
                    long l9 = ProfilingSpanReporter.profilingReportOnStart.get();
                    long l10 = ProfilingSpanReporter.addProfileCalledOnStart.get();
                    long l11 = ProfilingSpanReporter.profilingReportOnFinish.get();
                    long l12 = ProfilingSpanReporter.traceIdChanged.get();
                    CustomMetricsCollector.INSTANCE.recordSummaryMetric("profiler.startProfileCnt", l2, 1, null);
                    CustomMetricsCollector.INSTANCE.recordSummaryMetric("profiler.stopProfileCalled", l3, 1, null);
                    CustomMetricsCollector.INSTANCE.recordSummaryMetric("profiler.stopProfileCnt", l4, 1, null);
                    CustomMetricsCollector.INSTANCE.recordSummaryMetric("profiler.stopProfileCalledOnInvalidTraceId", l5, 1, null);
                    CustomMetricsCollector.INSTANCE.recordSummaryMetric("profiler.traceIdNotFoundWhenStop", l6, 1, null);
                    CustomMetricsCollector.INSTANCE.recordSummaryMetric("profiler.profileByIdMapSize", l7, 1, null);
                    CustomMetricsCollector.INSTANCE.recordSummaryMetric("profiler.expiredProfile", l8, 1, null);
                    CustomMetricsCollector.INSTANCE.recordSummaryMetric("profilingSpanReporter.profilingReportOnStart", l9, 1, null);
                    CustomMetricsCollector.INSTANCE.recordSummaryMetric("profilingSpanReporter.addProfileCalledOnStart", l10, 1, null);
                    CustomMetricsCollector.INSTANCE.recordSummaryMetric("profilingSpanReporter.profilingReportOnFinish", l11, 1, null);
                    CustomMetricsCollector.INSTANCE.recordSummaryMetric("profilingSpanReporter.traceIdChanged", l12, 1, null);
                    b.debug(String.format("[Profiler counters] startProfileCnt=%d, stopProfileCalled=%d, stopProfileCalledOnInvalidTraceId=%d, traceIdNotFoundWhenStop=%d, profileByIdMapSize=%d, expiredProfile=%d\n[ProfilingSpanReporter counters] profilingReportOnStart=%d, addProfileCalledOnStart=%d, profilingReportOnFinish=%d", l2, l3, l5, l6, l7, l8, l9, l10, l11));
                    return;
                }
                catch (Throwable throwable) {
                    b.info("An exception is caught by the startProfilerCounterReporter but it will be scheduled to run again next time.", throwable);
                    return;
                }
            }
        }, 20L, 60L, TimeUnit.SECONDS);
        b.info("startProfilerCounterReporter scheduled to run every 60 seconds.");
    }
}

