/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe;

import com.tracelytics.joboe.Event;
import com.tracelytics.joboe.QueuingEventReporter;
import com.tracelytics.joboe.rpc.Client;
import com.tracelytics.joboe.rpc.ClientException;
import com.tracelytics.joboe.rpc.ClientLoggingCallback;
import com.tracelytics.joboe.rpc.Result;
import com.tracelytics.joboe.rpc.RpcClientManager;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpcEventReporter
extends QueuingEventReporter {
    private final Client d;
    private ClientLoggingCallback<Result> e = new ClientLoggingCallback("send events");

    public RpcEventReporter(Client client) throws IOException {
        this.d = client;
    }

    @Override
    public Result synchronousSend(List<Event> list) throws InterruptedException, ExecutionException, ClientException {
        return this.d.postEvents(list, this.e).get();
    }

    @Override
    public void close() {
        if (this.d.getStatus() != Client.Status.OK) {
            b.debug("RPC client is not OK. Shutting down the service now");
            this.a.shutdownNow();
        }
        super.close();
    }

    public static RpcEventReporter buildReporter(RpcClientManager.OperationType operationType) {
        try {
            return new RpcEventReporter(RpcClientManager.getClient(operationType));
        }
        catch (IOException iOException) {
            b.warn("Failed to initialize Event reporter for event: " + iOException.getMessage(), iOException);
            return null;
        }
        catch (ClientException clientException) {
            b.warn("Failed to initialize Event reporter for event: " + clientException.getMessage(), clientException);
            return null;
        }
    }
}

