/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe;

import com.tracelytics.joboe.Context;
import com.tracelytics.joboe.HostId;
import com.tracelytics.joboe.Metadata;
import com.tracelytics.joboe.config.ConfigManager;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.rpc.HostType;
import com.tracelytics.joboe.span.impl.ScopeContextSnapshot;
import com.tracelytics.joboe.span.impl.ScopeManager;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import com.tracelytics.util.DaemonThreadFactory;
import com.tracelytics.util.ExecUtils;
import com.tracelytics.util.HostInfoReader;
import com.tracelytics.util.HostInfoUtils;
import com.tracelytics.util.JavaProcessUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentHostInfoReader
implements HostInfoReader {
    public static final AgentHostInfoReader INSTANCE = new AgentHostInfoReader();
    private static Logger a = LoggerFactory.getLogger();
    private static String b;
    private static HostId c;
    private static String d;
    private static boolean e;
    private static HostInfoUtils.OsType f;
    private static Map<a, String> g;
    public static final String HOSTNAME_ALIAS_KEY = "ConfiguredHostname";

    private AgentHostInfoReader() {
    }

    public String getAwsInstanceId() {
        return Ec2InstanceReader.getInstanceId();
    }

    public String getAwsAvailabilityZone() {
        return Ec2InstanceReader.getAvailabilityZone();
    }

    public String getDockerContainerId() {
        return DockerInfoReader.getDockerId();
    }

    public String getHerokuDynoId() {
        return HerokuDynoReader.getDynoId();
    }

    @Override
    public String getAzureInstanceId() {
        return AzureReader.getInstanceId();
    }

    private static void a(Map<String, b> map) {
        Object[] objectArray;
        try {
            objectArray = ExecUtils.exec("powershell.exe Get-NetAdapter -IncludeHidden | Select-Object InterfaceDescription,Status | Format-Table -AutoSize", System.getProperty("line.separator"));
        }
        catch (Exception exception) {
            a.info("Failed to obtain nic status from exec `Get-NetAdapter` : " + exception.getMessage());
            return;
        }
        objectArray = objectArray.split(System.getProperty("line.separator"));
        if (objectArray.length < 3) {
            a.info("No enough data received from exec `Get-NetAdapter`(" + objectArray.length + "): " + Arrays.toString(objectArray));
            return;
        }
        String string = objectArray[0];
        int n2 = string.indexOf("Status");
        if (n2 == -1) {
            a.info("Failed to obtain nic status as the header `Status` is not found. " + Arrays.toString(objectArray));
            return;
        }
        String[] stringArray = (String[])Arrays.copyOfRange(objectArray, 2, objectArray.length);
        objectArray = stringArray;
        objectArray = stringArray;
        int n3 = stringArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = objectArray[i2];
            if (n2 > ((String)object).length()) continue;
            String string2 = ((String)object).substring(0, n2).trim();
            object = com.tracelytics.joboe.AgentHostInfoReader$b.a(((String)object).substring(n2).trim());
            a.debug("Get device display name=" + string2 + ", status=" + object);
            map.put(string2, (b)((Object)object));
        }
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public HostInfoUtils.NetworkAddressInfo getNetworkAddressInfo() {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            HashMap<String, b> hashMap = new HashMap<String, b>();
            boolean bl = false;
            if (f.equals((Object)HostInfoUtils.OsType.WINDOWS) && Boolean.getBoolean("java.net.preferIPv4Stack")) {
                AgentHostInfoReader.a(hashMap);
                bl = true;
            }
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                try {
                    Object object;
                    a.debug("Found network interface " + networkInterface.getName() + " " + networkInterface.getDisplayName());
                    if (networkInterface.isLoopback() || networkInterface.isPointToPoint() || !AgentHostInfoReader.a(networkInterface) || AgentHostInfoReader.b(networkInterface)) continue;
                    a.debug("Processing physical network interface " + networkInterface.getName() + " " + networkInterface.getDisplayName());
                    boolean bl2 = false;
                    for (Object object2 : Collections.list(networkInterface.getInetAddresses())) {
                        object2 = ((InetAddress)object2).getHostAddress();
                        a.debug("Found ip address " + (String)object2);
                        if (!arrayList.contains(object2)) {
                            arrayList.add((String)object2);
                        }
                        bl2 = true;
                    }
                    if (bl) {
                        object = (b)((Object)hashMap.get(networkInterface.getDisplayName()));
                        a.debug("Checking " + networkInterface.getName() + ", " + networkInterface.getDisplayName() + ", status=" + object);
                        if (!com.tracelytics.joboe.AgentHostInfoReader$b.a.equals(object) && !com.tracelytics.joboe.AgentHostInfoReader$b.b.equals(object)) {
                            a.debug("Ignore disabled/null network adapter " + networkInterface.getDisplayName() + ", status=" + object);
                            continue;
                        }
                        if (com.tracelytics.joboe.AgentHostInfoReader$b.a.equals(object) && !bl2) {
                            a.debug("Ignore network adapter which is up but no IP assigned: " + networkInterface.getDisplayName());
                            continue;
                        }
                    } else if (!bl2) {
                        a.debug("Ignore network adapter without an IP: " + networkInterface.getName());
                        continue;
                    }
                    byte[] byArray = networkInterface.getHardwareAddress();
                    object = byArray;
                    if (byArray == null || ((Iterator<InetAddress>)object).length == 0) continue;
                    String string = AgentHostInfoReader.a(object);
                    a.debug("Found MAC address " + string);
                    if (arrayList2.contains(string)) continue;
                    arrayList2.add(string);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    a.debug("Failed to get network info for " + networkInterface.getName() + ", probably running JDK 1.5 or earlier");
                }
                catch (SocketException socketException) {
                    a.debug("Failed to get network info for " + networkInterface.getName() + ":" + socketException.getMessage());
                }
            }
            a.debug("All MAC addresses accepted: " + Arrays.toString(arrayList2.toArray()));
            return new HostInfoUtils.NetworkAddressInfo(arrayList, arrayList2);
        }
        catch (SocketException socketException) {
            a.warn("Failed to get network info : " + socketException.getMessage());
            return null;
        }
    }

    private static boolean a(NetworkInterface object) {
        if (f != HostInfoUtils.OsType.LINUX) {
            return true;
        }
        object = "/sys/class/net/" + ((NetworkInterface)object).getName();
        File file = new File((String)object);
        try {
            return !file.getCanonicalPath().contains("/virtual/");
        }
        catch (IOException iOException) {
            a.warn("Error identifying network interface in " + (String)object + " message : " + iOException.getMessage(), iOException);
            return true;
        }
    }

    private static boolean b(NetworkInterface networkInterface) {
        try {
            String string = networkInterface.getDisplayName();
            return string != null && string.startsWith("Microsoft Hyper-V Network Adapter") && !networkInterface.isUp();
        }
        catch (SocketException socketException) {
            a.debug("Cannot call isUp on " + networkInterface.getDisplayName(), socketException);
            return false;
        }
    }

    private static String a(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(18);
        for (byte by : byArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(':');
            }
            stringBuilder.append(String.format("%02x", by));
        }
        return stringBuilder.toString().toUpperCase();
    }

    @Override
    public synchronized String getHostName() {
        if (d == null) {
            d = AgentHostInfoReader.loadHostName();
        }
        return d;
    }

    @Override
    public synchronized HostId getHostId() {
        if (c == null) {
            Metadata metadata = null;
            ScopeContextSnapshot scopeContextSnapshot = null;
            try {
                metadata = Context.getMetadata();
                scopeContextSnapshot = ScopeManager.INSTANCE.getSnapshot();
                Context.clearMetadata();
                ScopeManager.INSTANCE.removeAllScopes();
                c = this.f();
                AgentHostInfoReader agentHostInfoReader = this;
                ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, DaemonThreadFactory.newInstance("host-id-checker"));
                long l2 = 60000L - System.currentTimeMillis() % 60000L;
                scheduledExecutorService.scheduleAtFixedRate(new Runnable(agentHostInfoReader){
                    private /* synthetic */ AgentHostInfoReader a;
                    {
                        this.a = agentHostInfoReader;
                    }

                    public final void run() {
                        c = this.a.f();
                    }
                }, l2, 60000L, TimeUnit.MILLISECONDS);
            }
            finally {
                Context.setMetadata(metadata);
                scopeContextSnapshot.restore();
            }
        }
        return c;
    }

    public static String loadHostName() {
        String string = AgentHostInfoReader.c();
        if (string != null) {
            return string;
        }
        string = AgentHostInfoReader.d();
        if (string != null) {
            return string;
        }
        string = "unknown_hostname";
        return "unknown_hostname";
    }

    private static String c() {
        try {
            return ExecUtils.exec("hostname");
        }
        catch (Exception exception) {
            a.info("Failed to obtain host name from exec `hostname` : " + exception.getMessage());
            return null;
        }
    }

    private static String d() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            try {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement();
                    object = ((NetworkInterface)object).getInetAddresses();
                    while (object.hasMoreElements()) {
                        InetAddress inetAddress = (InetAddress)object.nextElement();
                        if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                        return inetAddress.getHostAddress();
                    }
                }
            }
            catch (SocketException socketException) {
                a.warn("Unable to retrieve network interfaces", socketException);
            }
            return null;
        }
    }

    public static String getDistro() {
        if (!e) {
            if (f == HostInfoUtils.OsType.LINUX) {
                b = AgentHostInfoReader.e();
            } else if (f == HostInfoUtils.OsType.WINDOWS) {
                b = ManagementFactory.getOperatingSystemMXBean().getName();
            }
            e = true;
        }
        return b;
    }

    @Override
    public Map<String, Object> getHostMetadata() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object object = (String)ConfigManager.getConfig(ConfigProperty.AGENT_HOSTNAME_ALIAS);
        if (object != null) {
            hashMap.put(HOSTNAME_ALIAS_KEY, object);
        }
        object = hashMap;
        object.put("UnameSysName", f.getLabel());
        object.put("UnameVersion", ManagementFactory.getOperatingSystemMXBean().getVersion());
        Object object2 = AgentHostInfoReader.getDistro();
        if (object2 != null) {
            object.put("Distro", object2);
        }
        object2 = hashMap;
        object = this;
        if ((object = ((AgentHostInfoReader)object).getNetworkAddressInfo()) != null) {
            object2.put("IPAddresses", ((HostInfoUtils.NetworkAddressInfo)object).getIpAddresses());
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String e() {
        String string;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = AgentHostInfoReader.a(com.tracelytics.joboe.AgentHostInfoReader$a.d);
            if (bufferedReader != null) {
                Object object = bufferedReader;
                object = (object = ((BufferedReader)object).readLine()) != null ? object : "Red Hat based unknown";
                return object;
            }
            bufferedReader = AgentHostInfoReader.a(com.tracelytics.joboe.AgentHostInfoReader$a.a);
            if (bufferedReader != null) {
                String string2;
                Object object = bufferedReader;
                if ((object = object.readLine()) != null && ((String[])(object = object.split(":"))).length >= 5) {
                    object = object[4];
                    string2 = "Amzn Linux " + (String)object;
                } else {
                    string2 = "Amzn Linux unknown";
                }
                object = string2;
                return object;
            }
            bufferedReader = AgentHostInfoReader.a(com.tracelytics.joboe.AgentHostInfoReader$a.b);
            if (bufferedReader != null) {
                String string3 = AgentHostInfoReader.a(bufferedReader);
                return string3;
            }
            bufferedReader = AgentHostInfoReader.a(com.tracelytics.joboe.AgentHostInfoReader$a.c);
            if (bufferedReader != null) {
                Object object = bufferedReader;
                object = (object = ((BufferedReader)object).readLine()) != null ? "Debian " + (String)object : "Debian unknown";
                return object;
            }
            bufferedReader = AgentHostInfoReader.a(com.tracelytics.joboe.AgentHostInfoReader$a.e);
            if (bufferedReader != null) {
                Object object = bufferedReader;
                object = (object = ((BufferedReader)object).readLine()) != null ? object : "Novell SuSE unknown";
                return object;
            }
            bufferedReader = AgentHostInfoReader.a(com.tracelytics.joboe.AgentHostInfoReader$a.f);
            if (bufferedReader != null) {
                Object object = bufferedReader;
                object = (object = ((BufferedReader)object).readLine()) != null ? object : "Slackware unknown";
                return object;
            }
            bufferedReader = AgentHostInfoReader.a(com.tracelytics.joboe.AgentHostInfoReader$a.f);
            if (bufferedReader != null) {
                Object object = bufferedReader;
                object = (object = ((BufferedReader)object).readLine()) != null ? object : "Gentoo unknown";
                return object;
            }
            string = "Unknown";
            if (bufferedReader == null) return string;
        }
        catch (IOException iOException) {
            a.warn("Problem reading distro file : " + iOException.getMessage(), iOException);
            String string4 = "Unknown";
            return string4;
        }
        try {
            bufferedReader.close();
            return string;
        }
        catch (IOException iOException) {
            a.warn(iOException.getMessage(), iOException);
        }
        return string;
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    a.warn(iOException.getMessage(), iOException);
                }
            }
        }
    }

    private static String a(BufferedReader object) throws IOException {
        String[] stringArray;
        while ((stringArray = ((BufferedReader)object).readLine()) != null) {
            if ((stringArray = stringArray.split("=")).length < 2 || !"DISTRIB_DESCRIPTION".equals(stringArray[0])) continue;
            object = stringArray[1];
            if (((String)object).startsWith("\"")) {
                object = ((String)object).substring(1);
            }
            if (((String)object).endsWith("\"")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            return object;
        }
        return "Ubuntu unknown";
    }

    private static BufferedReader a(a object) {
        String string = g.get(object);
        if (string == null) {
            a.warn("Unexpected distroType lookup: " + object);
            return null;
        }
        object = new File(string);
        try {
            if (((File)object).exists()) {
                return new BufferedReader(new FileReader((File)object));
            }
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            a.warn(fileNotFoundException.getMessage(), fileNotFoundException);
            return null;
        }
    }

    private HostId f() {
        Object object = this.getNetworkAddressInfo();
        object = object != null ? ((HostInfoUtils.NetworkAddressInfo)object).getMacAddresses() : Collections.emptyList();
        return new HostId(this.getHostName(), JavaProcessUtils.getPid(), (List<String>)object, Ec2InstanceReader.getInstanceId(), Ec2InstanceReader.getAvailabilityZone(), DockerInfoReader.getDockerId(), HerokuDynoReader.getDynoId(), AzureReader.getInstanceId(), HostType.PERSISTENT);
    }

    static {
        e = false;
        f = HostInfoUtils.getOsType();
        g = new HashMap<a, String>();
        g.put(com.tracelytics.joboe.AgentHostInfoReader$a.a, "/etc/system-release-cpe");
        g.put(com.tracelytics.joboe.AgentHostInfoReader$a.d, "/etc/redhat-release");
        g.put(com.tracelytics.joboe.AgentHostInfoReader$a.b, "/etc/lsb-release");
        g.put(com.tracelytics.joboe.AgentHostInfoReader$a.c, "/etc/debian_version");
        g.put(com.tracelytics.joboe.AgentHostInfoReader$a.e, "/etc/SuSE-release");
        g.put(com.tracelytics.joboe.AgentHostInfoReader$a.f, "/etc/slackware-version");
        g.put(com.tracelytics.joboe.AgentHostInfoReader$a.g, "/etc/gentoo-release");
    }

    public static class AzureReader {
        private static final AzureReader a = new AzureReader();
        private final String b = System.getenv("WEBSITE_INSTANCE_ID");

        public static String getInstanceId() {
            return AzureReader.a.b;
        }

        private AzureReader() {
            if (this.b != null) {
                a.debug("Found Azure instance ID: " + this.b);
            }
        }
    }

    public static class HerokuDynoReader {
        private static final HerokuDynoReader a = new HerokuDynoReader();
        private final String b = System.getenv("DYNO");

        public static String getDynoId() {
            return HerokuDynoReader.a.b;
        }

        private HerokuDynoReader() {
            if (this.b != null) {
                a.debug("Found Heroku Dyno ID: " + this.b);
            }
        }
    }

    public static class DockerInfoReader {
        public static final String DEFAULT_LINUX_DOCKER_FILE_LOCATION = "/proc/self/cgroup";
        private static final Set<String> a = new HashSet<String>();
        private String b;
        private static DockerInfoReader c;

        public static String getDockerId() {
            return DockerInfoReader.c.b;
        }

        private DockerInfoReader() {
            if (f == HostInfoUtils.OsType.LINUX) {
                this.a(DEFAULT_LINUX_DOCKER_FILE_LOCATION);
            } else if (f == HostInfoUtils.OsType.WINDOWS) {
                DockerInfoReader dockerInfoReader = this;
                try {
                    String string = ExecUtils.exec("powershell Get-ItemProperty -Path HKLM:\\SYSTEM\\CurrentControlSet\\Control\\ -Name \"ContainerType\"");
                    if (string != null && !"".equals(string)) {
                        dockerInfoReader.b = INSTANCE.getHostName();
                    }
                }
                catch (Exception exception) {
                    a.info("Failed to identify whether this windows system is a docker container: " + exception.getMessage());
                }
            }
            if (this.b != null) {
                a.debug("Found Docker instance ID :" + this.b);
                return;
            }
            a.debug("Cannot locate Docker id, not a Docker container");
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void a(String var1_1) {
            var2_4 = null;
            try {
                var2_4 = new BufferedReader(new FileReader(var1_1));
                while (true) {
                    if ((var3_6 = var2_4.readLine()) != null) {
                        if (Collections.disjoint(var3_6 = Arrays.asList(var3_6.split("/")), DockerInfoReader.a)) continue;
                    } else {
                        this.b = null;
                        try {
                            var2_4.close();
                            return;
                        }
                        catch (IOException var3_7) {
                            AgentHostInfoReader.a().warn(var3_7.getMessage(), var3_7);
                            return;
                        }
                    }
                    var3_6 = var3_6.iterator();
                    do {
                        if (!var3_6.hasNext()) ** break;
                    } while ((var4_12 = (String)var3_6.next()).length() != 64);
                    break;
                }
                this.b = var4_12;
                try {
                    var2_4.close();
                    return;
                }
                catch (IOException var1_2) {
                    AgentHostInfoReader.a().warn(var1_2.getMessage(), var1_2);
                    return;
                }
            }
            catch (FileNotFoundException var3_8) {
                this.b = null;
                AgentHostInfoReader.a().debug("Cannot locate docker id as file " + var1_1 + " cannot be found : " + var3_8.getMessage());
                if (var2_4 == null) return;
                {
                    catch (Throwable var1_3) {
                        if (var2_4 == null) throw var1_3;
                        try {
                            var2_4.close();
                            throw var1_3;
                        }
                        catch (IOException var2_5) {
                            AgentHostInfoReader.a().warn(var2_5.getMessage(), var2_5);
                        }
                        throw var1_3;
                    }
                }
                try {
                    var2_4.close();
                    return;
                }
                catch (IOException var3_9) {
                    AgentHostInfoReader.a().warn(var3_9.getMessage(), var3_9);
                    return;
                }
                catch (IOException var3_10) {
                    this.b = null;
                    AgentHostInfoReader.a().debug("Cannot locate docker id as file " + var1_1 + " throws IOException : " + var3_10.getMessage());
                    if (var2_4 == null) return;
                    try {
                        var2_4.close();
                        return;
                    }
                    catch (IOException var3_11) {
                        AgentHostInfoReader.a().warn(var3_11.getMessage(), var3_11);
                        return;
                    }
                }
            }
        }

        static {
            a.add("docker");
            a.add("ecs");
            a.add("kubepods");
            a.add("docker.service");
            c = new DockerInfoReader();
        }
    }

    public static class Ec2InstanceReader {
        private static final int a;
        public static final String EC2_METADATA_SERVICE_OVERRIDE_SYSTEM_PROPERTY = "com.amazonaws.sdk.ec2MetadataServiceEndpointOverride";
        private String b;
        private String c;
        private static final Ec2InstanceReader d;

        public static String getInstanceId() {
            return Ec2InstanceReader.d.b;
        }

        public static String getAvailabilityZone() {
            return Ec2InstanceReader.d.c;
        }

        private Ec2InstanceReader() {
            Ec2InstanceReader ec2InstanceReader = this;
            if (a != 0) {
                ec2InstanceReader.b = Ec2InstanceReader.a("latest/meta-data/instance-id");
                if (ec2InstanceReader.b != null) {
                    ec2InstanceReader.c = Ec2InstanceReader.a("latest/meta-data/placement/availability-zone");
                    a.debug("Found EC2 instance id " + ec2InstanceReader.b + " availability zone: " + ec2InstanceReader.c);
                }
            }
        }

        /*
         * Loose catch block
         */
        private static String a(String object) {
            Object object2;
            HttpURLConnection httpURLConnection;
            block20: {
                httpURLConnection = null;
                object2 = null;
                String string = System.getProperty(EC2_METADATA_SERVICE_OVERRIDE_SYSTEM_PROPERTY);
                object = new URI((string != null ? string : "http://169.254.169.254") + "/" + (String)object);
                httpURLConnection = (HttpURLConnection)((URI)object).toURL().openConnection(Proxy.NO_PROXY);
                httpURLConnection.setConnectTimeout(a);
                httpURLConnection.setReadTimeout(a);
                int n2 = httpURLConnection.getResponseCode();
                if (n2 != 200) break block20;
                object2 = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                String string2 = ((BufferedReader)object2).readLine();
                try {
                    ((BufferedReader)object2).close();
                }
                catch (IOException iOException) {
                    object2 = iOException;
                    iOException.printStackTrace();
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                return string2;
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return null;
            catch (IOException iOException) {
                block21: {
                    a.debug("Timeout on reading EC2 metadata after waiting for [" + a + "] milliseconds. Probably not an EC2 instance");
                    if (object2 == null) break block21;
                    try {
                        ((BufferedReader)object2).close();
                    }
                    catch (IOException iOException2) {
                        object = iOException2;
                        iOException2.printStackTrace();
                    }
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                block22: {
                    a.warn(uRISyntaxException.getMessage(), uRISyntaxException);
                    if (object2 == null) break block22;
                    {
                        catch (Throwable throwable) {
                            if (object2 != null) {
                                try {
                                    ((BufferedReader)object2).close();
                                }
                                catch (IOException iOException) {
                                    object2 = iOException;
                                    iOException.printStackTrace();
                                }
                            }
                            if (httpURLConnection != null) {
                                httpURLConnection.disconnect();
                            }
                            throw throwable;
                        }
                    }
                    try {
                        ((BufferedReader)object2).close();
                    }
                    catch (IOException iOException) {
                        IOException iOException3 = iOException;
                        iOException.printStackTrace();
                    }
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                return null;
            }
        }

        static {
            int n2;
            Integer n3 = (Integer)ConfigManager.getConfig(ConfigProperty.AGENT_EC2_METADATA_TIMEOUT);
            if (n3 == null) {
                n2 = 1000;
            } else if (n3 > 3000) {
                a.warn("EC2 metadata read timeout cannot be greater than 3000 millisec but found [" + n3 + "]. Using 3000" + " instead.");
                n2 = 3000;
            } else if (n3 < 0) {
                a.warn("EC2 metadata read timeout cannot be smaller than 0 millisec but found [" + n3 + "]. Using 0" + " instead, which essentially disable reading EC2 metadata");
                n2 = 0;
            } else {
                n2 = n3;
            }
            a = n2;
            d = new Ec2InstanceReader();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum b {
        c("Not Present"),
        a("Up"),
        b("Disconnected");

        private final String d;
        private static final Map<String, b> e;

        private b(String string2) {
            this.d = string2;
        }

        public static b a(String string) {
            return e.get(string);
        }

        static {
            ConcurrentHashMap<String, b> concurrentHashMap = new ConcurrentHashMap<String, b>();
            b[] bArray = com.tracelytics.joboe.AgentHostInfoReader$b.values();
            int n2 = bArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                b b2;
                b b3 = b2 = bArray[i2];
                concurrentHashMap.put(b3.d, b2);
            }
            e = Collections.unmodifiableMap(concurrentHashMap);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum a {
        a,
        b,
        c,
        d,
        e,
        f,
        g;

    }
}

