/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.instrumentation.nosql.cassandra;

import com.tracelytics.a.f.g;
import com.tracelytics.a.f.j;
import com.tracelytics.a.f.l;
import com.tracelytics.a.f.o;
import com.tracelytics.a.f.t;
import com.tracelytics.instrumentation.MethodMatcher;
import com.tracelytics.instrumentation.Module;
import com.tracelytics.instrumentation.TvContextObjectAware;
import com.tracelytics.instrumentation.jdbc.SQLSanitizer;
import com.tracelytics.instrumentation.nosql.cassandra.CassandraBaseInstrumentation;
import com.tracelytics.instrumentation.nosql.cassandra.SessionWithKeyspace;
import com.tracelytics.instrumentation.nosql.cassandra.StatementWithParameters;
import com.tracelytics.instrumentation.nosql.cassandra.StatementWithQueryString;
import com.tracelytics.joboe.Context;
import com.tracelytics.joboe.Event;
import com.tracelytics.joboe.Metadata;
import com.tracelytics.joboe.config.ConfigManager;
import com.tracelytics.joboe.config.ConfigProperty;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CassandraSessionInstrumentation
extends CassandraBaseInstrumentation {
    public static final int CQL_MAX_LENGTH = 2048;
    private static final String f = CassandraSessionInstrumentation.class.getName();
    private static SQLSanitizer g;
    private static final ThreadLocal<Metadata> h;
    private static final Integer i;
    private static List<MethodMatcher<a>> j;

    @Override
    public boolean applyInstrumentation(g g2, String object, byte[] byArray) throws Exception {
        boolean bl;
        try {
            g2.a("getLoggedKeyspace", "()Ljava/lang/String;");
            bl = true;
        }
        catch (t t2) {
            bl = false;
        }
        for (Map.Entry entry : this.a(g2, j).entrySet()) {
            l l2 = entry.getKey();
            if (!CassandraSessionInstrumentation.shouldModify(g2, l2)) continue;
            a a2 = (a)((Object)entry.getValue());
            if (a2 == com.tracelytics.instrumentation.nosql.cassandra.CassandraSessionInstrumentation$a.a) {
                StringBuffer stringBuffer = new StringBuffer(f + ".layerEntry(this, $1, getCluster() != null && getCluster().getMetadata() != null ? getCluster().getMetadata().getClusterName() : null, ");
                if (bl) {
                    stringBuffer.append("getLoggedKeyspace(), ");
                } else {
                    stringBuffer.append("null, ");
                }
                stringBuffer.append("$1 != null ? $1.getConsistencyLevel() : null);");
                CassandraSessionInstrumentation.insertBefore(l2, stringBuffer.toString());
                CassandraSessionInstrumentation.addErrorReporting(l2, "com.datastax.driver.core.exceptions.DriverException", (String)object, this.d);
                CassandraSessionInstrumentation.insertAfter(l2, f + ".layerExit($_ != null && $_.getExecutionInfo() != null && $_.getExecutionInfo().getQueriedHost() != null ? $_.getExecutionInfo().getQueriedHost().getAddress() : null);", true);
                continue;
            }
            if (a2 != com.tracelytics.instrumentation.nosql.cassandra.CassandraSessionInstrumentation$a.b) continue;
            StringBuffer stringBuffer = new StringBuffer(f + ".layerEntryAsync(this, $1, getCluster() != null && getCluster().getMetadata() != null ? getCluster().getMetadata().getClusterName() : null, ");
            if (bl) {
                stringBuffer.append("getLoggedKeyspace(), ");
            } else {
                stringBuffer.append("null, ");
            }
            stringBuffer.append("$1 != null ? $1.getConsistencyLevel() : null);");
            CassandraSessionInstrumentation.insertBefore(l2, stringBuffer.toString());
            CassandraSessionInstrumentation.insertAfter(l2, f + ".recordContext($_);", true);
        }
        Object object3 = com.tracelytics.a.f.j.a("private String tvKeyspace;", g2);
        object = g2;
        ((g)object).a((j)object3, (j.c)null);
        object3 = g2;
        object = "public void tvSetKeyspace(String keyspace) { tvKeyspace = keyspace; }";
        g2.a(o.a("public void tvSetKeyspace(String keyspace) { tvKeyspace = keyspace; }", (g)object3, null, null));
        object3 = g2;
        object = "public String tvGetKeyspace() { return tvKeyspace; }";
        g2.a(o.a("public String tvGetKeyspace() { return tvKeyspace; }", (g)object3, null, null));
        this.a(g2, SessionWithKeyspace.class.getName());
        return true;
    }

    public static void layerEntry(Object object, Object sortedMap, String string, String string2, Object object2) {
        if (CassandraSessionInstrumentation.a()) {
            Object object3;
            Event event = Context.createEvent();
            event.addInfo("Layer", "cql", "Label", "entry", "Flavor", "cql");
            if (sortedMap instanceof StatementWithQueryString) {
                object3 = ((StatementWithQueryString)((Object)sortedMap)).tvGetQueryString();
                if (g != null) {
                    object3 = g.sanitizeQuery((String)object3);
                }
                if (((String)object3).length() > 2048) {
                    object3 = ((String)object3).substring(0, 2048);
                    event.addInfo("QueryTruncated", (Object)Boolean.TRUE);
                    a.debug("CQL Query trimmed as its length [" + ((String)object3).length() + "] exceeds max [2048" + "]");
                }
                event.addInfo("Query", object3);
            }
            if (sortedMap instanceof StatementWithParameters && (sortedMap = (object3 = (StatementWithParameters)((Object)sortedMap)).tvGetParameters()) != null && !sortedMap.isEmpty()) {
                event.addInfo("QueryArgs", (Object)object3.tvGetParameters().values().toArray());
            }
            if (string != null) {
                event.addInfo("ClusterName", (Object)string);
            }
            if (string2 != null) {
                event.addInfo("Keyspace", (Object)string2);
            } else if (object instanceof SessionWithKeyspace && ((SessionWithKeyspace)object).tvGetKeyspace() != null) {
                event.addInfo("Keyspace", (Object)((SessionWithKeyspace)object).tvGetKeyspace());
            }
            if (object2 != null) {
                event.addInfo("ConsistencyLevel", (Object)object2.toString());
            }
            CassandraSessionInstrumentation.addBackTrace(event, 1, Module.CASSANDRA);
            event.report();
        }
    }

    public static void layerExit(Object object) {
        if (CassandraSessionInstrumentation.b()) {
            Event event = Context.createEvent();
            event.addInfo("Layer", "cql", "Label", "exit");
            if (object != null && (object instanceof InetAddress || object instanceof InetSocketAddress)) {
                if (((String)(object = object.toString())).startsWith("/")) {
                    object = ((String)object).substring(1);
                }
                event.addInfo("RemoteHost", object);
            }
            event.report();
        }
    }

    public static void layerEntryAsync(Object object, Object object2, String string, String string2, Object object3) {
        if (CassandraSessionInstrumentation.a()) {
            Object object4;
            object = Context.getMetadata();
            Object object5 = new Metadata((Metadata)object);
            Context.setMetadata((Metadata)object5);
            object5 = Context.createEvent();
            ((Event)object5).addInfo("Layer", "cql", "Label", "entry", "Flavor", "cql");
            if (object2 instanceof StatementWithQueryString) {
                object4 = ((StatementWithQueryString)object2).tvGetQueryString();
                if (g != null) {
                    object4 = g.sanitizeQuery((String)object4);
                }
                if (((String)object4).length() > 2048) {
                    object4 = ((String)object4).substring(0, 2048);
                    ((Event)object5).addInfo("QueryTruncated", (Object)Boolean.TRUE);
                    a.debug("CQL Query trimmed as its length [" + ((String)object4).length() + "] exceeds max [2048" + "]");
                }
                ((Event)object5).addInfo("Query", object4);
            }
            if (object2 instanceof StatementWithParameters && !(object4 = (StatementWithParameters)object2).tvGetParameters().isEmpty()) {
                ((Event)object5).addInfo("QueryArgs", (Object)object4.tvGetParameters().values().toArray());
            }
            if (string != null) {
                ((Event)object5).addInfo("ClusterName", (Object)string);
            }
            if (string2 != null) {
                ((Event)object5).addInfo("Keyspace", (Object)string2);
            }
            if (object3 != null) {
                ((Event)object5).addInfo("ConsistencyLevel", (Object)object3.toString());
            }
            CassandraSessionInstrumentation.addBackTrace((Event)object5, 1, Module.CASSANDRA);
            ((Event)object5).report();
            h.set(Context.getMetadata());
            Context.setMetadata((Metadata)object);
        }
    }

    public static void recordContext(Future<?> object) {
        Metadata metadata = h.get();
        if (CassandraSessionInstrumentation.b()) {
            if (object.isDone()) {
                object = Context.createEvent();
                ((Event)object).addInfo("Layer", "cql", "Label", "exit");
                ((Event)object).setAsync();
                ((Event)object).report();
            } else if (object instanceof TvContextObjectAware) {
                ((TvContextObjectAware)object).setTvContext(metadata);
            }
        }
        h.remove();
    }

    static {
        h = new ThreadLocal();
        i = 1;
        j = Arrays.asList(new MethodMatcher<a>("execute", new String[]{"com.datastax.driver.core.Query"}, "com.datastax.driver.core.ResultSet", com.tracelytics.instrumentation.nosql.cassandra.CassandraSessionInstrumentation$a.a), new MethodMatcher<a>("execute", new String[]{"com.datastax.driver.core.Statement"}, "com.datastax.driver.core.ResultSet", com.tracelytics.instrumentation.nosql.cassandra.CassandraSessionInstrumentation$a.a), new MethodMatcher<a>("executeAsync", new String[]{"com.datastax.driver.core.Query"}, "com.datastax.driver.core.ResultSetFuture", com.tracelytics.instrumentation.nosql.cassandra.CassandraSessionInstrumentation$a.b), new MethodMatcher<a>("executeAsync", new String[]{"com.datastax.driver.core.Statement"}, "com.datastax.driver.core.ResultSetFuture", com.tracelytics.instrumentation.nosql.cassandra.CassandraSessionInstrumentation$a.b));
        Integer n2 = (Integer)ConfigManager.getConfig(ConfigProperty.AGENT_SQL_SANITIZE);
        int n3 = n2 != null ? n2 : i;
        g = SQLSanitizer.getSanitizer(n3, "com.datastax.driver.core.Statement");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum a {
        a,
        b;

    }
}

