/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.instrumentation.http.okhttp;

import com.tracelytics.a.f.g;
import com.tracelytics.a.f.l;
import com.tracelytics.instrumentation.ClassInstrumentation;
import com.tracelytics.instrumentation.MethodMatcher;
import com.tracelytics.instrumentation.Module;
import com.tracelytics.instrumentation.SpanAware;
import com.tracelytics.instrumentation.config.HideParamsConfig;
import com.tracelytics.joboe.Context;
import com.tracelytics.joboe.Metadata;
import com.tracelytics.joboe.OboeException;
import com.tracelytics.joboe.config.ConfigManager;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.span.impl.Scope;
import com.tracelytics.joboe.span.impl.ScopeManager;
import com.tracelytics.joboe.span.impl.Span;
import com.tracelytics.joboe.span.impl.TraceEventSpanReporter;
import com.tracelytics.joboe.span.impl.Tracer;
import com.tracelytics.util.HttpUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OkHttpCallInstrumentation
extends ClassInstrumentation {
    private static List<MethodMatcher<a>> f = Arrays.asList(new MethodMatcher<a>("execute", new String[0], "okhttp3.Response", com.tracelytics.instrumentation.http.okhttp.OkHttpCallInstrumentation$a.a), new MethodMatcher<a>("enqueue", new String[]{"okhttp3.Callback"}, "void", com.tracelytics.instrumentation.http.okhttp.OkHttpCallInstrumentation$a.b));
    private static boolean g = ConfigManager.getConfig(ConfigProperty.AGENT_HIDE_PARAMS) != null ? ((HideParamsConfig)ConfigManager.getConfig(ConfigProperty.AGENT_HIDE_PARAMS)).shouldHideParams(Module.APACHE_HTTP) : false;
    private static String h = OkHttpCallInstrumentation.class.getName();
    private static String i = "okhttp_client";

    public boolean applyInstrumentation(g g2, String string, byte[] object) throws Exception {
        object = this.a(g2, f).entrySet().iterator();
        while (object.hasNext()) {
            Object object2 = (Map.Entry)object.next();
            l l2 = (l)object2.getKey();
            if ((object2 = (a)((Object)object2.getValue())) == com.tracelytics.instrumentation.http.okhttp.OkHttpCallInstrumentation$a.a) {
                OkHttpCallInstrumentation.addErrorReporting(l2, Throwable.class.getName(), string, this.d);
                OkHttpCallInstrumentation.insertBefore(l2, h + ".beforeExecute(request().url() != null ? request().url().toString() : null, request().method(), request().header(\"X-Trace" + "\"));");
                OkHttpCallInstrumentation.insertAfter(l2, h + ".afterExecute($_ != null ? Integer.valueOf($_.code()) : null, $_ != null ? $_.header(\"X-Trace" + "\") : null);", true);
                continue;
            }
            if (object2 != com.tracelytics.instrumentation.http.okhttp.OkHttpCallInstrumentation$a.b) continue;
            OkHttpCallInstrumentation.insertBefore(l2, h + ".beforeEnqueue(request().url() != null ? request().url().toString() : null, request().method(), request().header(\"X-Trace" + "\"), this);");
        }
        this.b(g2);
        return true;
    }

    public static void beforeExecute(String object, String string, String string2) {
        Tracer.SpanBuilder spanBuilder = Tracer.INSTANCE.buildSpan(i).withReporters(TraceEventSpanReporter.REPORTER);
        spanBuilder.withTag("Spec", "rsc");
        if (object != null) {
            spanBuilder.withTag("RemoteURL", (String)(g ? HttpUtils.trimQueryParameters((String)object) : object));
        }
        if (string != null) {
            spanBuilder.withTag("HTTPMethod", string);
        }
        spanBuilder.withTag("IsService", true);
        if (string2 != null) {
            try {
                object = new Metadata(string2);
                if (((Metadata)object).taskHexString().equals(Context.getMetadata().taskHexString())) {
                    spanBuilder.withSpanProperty(Span.SpanProperty.ENTRY_XID, string2);
                } else {
                    a.warn("Failed to create entry event of OkHttp client call with metadata [" + string2 + "], the task ID is not the same as current trace");
                }
            }
            catch (OboeException oboeException) {
                a.warn("Failed to create entry event of OkHttp client call with metadata [" + string2 + "]");
            }
        }
        object = spanBuilder.startActive().span();
        OkHttpCallInstrumentation.addBackTrace((Span)object, 1, Module.OKHTTP);
    }

    public static void afterExecute(Integer n2, String string) {
        Scope scope = ScopeManager.INSTANCE.active();
        if (n2 != null) {
            scope.span().setTag("HTTPStatus", n2);
        }
        if (string != null) {
            scope.span().setSpanPropertyValue(Span.SpanProperty.CHILD_EDGES, Collections.singleton(string));
        }
        scope.close();
    }

    public static void beforeEnqueue(String object, String string, String string2, Object object2) {
        Tracer.SpanBuilder spanBuilder = Tracer.INSTANCE.buildSpan(i).withReporters(TraceEventSpanReporter.REPORTER);
        spanBuilder.withTag("Spec", "rsc");
        if (object != null) {
            spanBuilder.withTag("RemoteURL", (String)(g ? HttpUtils.trimQueryParameters((String)object) : object));
        }
        if (string != null) {
            spanBuilder.withTag("HTTPMethod", string);
        }
        spanBuilder.withTag("IsService", true);
        spanBuilder.withSpanProperty(Span.SpanProperty.IS_ASYNC, Boolean.TRUE);
        if (string2 != null) {
            try {
                object = new Metadata(string2);
                if (((Metadata)object).taskHexString().equals(Context.getMetadata().taskHexString())) {
                    spanBuilder.withSpanProperty(Span.SpanProperty.ENTRY_XID, string2);
                } else {
                    a.warn("Failed to create entry event of OkHttp client call with metadata [" + string2 + "], the task ID is not the same as current trace [" + Context.getMetadata().taskHexString() + "]");
                }
            }
            catch (OboeException oboeException) {
                a.warn("Failed to create entry event of OkHttp client call with metadata [" + string2 + "]");
            }
        }
        object = spanBuilder.startManual();
        OkHttpCallInstrumentation.addBackTrace((Span)object, 1, Module.OKHTTP);
        ((SpanAware)object2).tvSetSpan((Span)object);
    }

    public static interface Callback {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum a {
        a,
        b;

    }
}

