/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.instrumentation.http.jetty;

import com.tracelytics.a.f.f;
import com.tracelytics.a.f.g;
import com.tracelytics.a.f.l;
import com.tracelytics.a.f.o;
import com.tracelytics.a.f.t;
import com.tracelytics.instrumentation.ClassInstrumentation;
import com.tracelytics.instrumentation.MethodMatcher;
import com.tracelytics.instrumentation.Module;
import com.tracelytics.instrumentation.SpanAware;
import com.tracelytics.instrumentation.config.HideParamsConfig;
import com.tracelytics.instrumentation.http.jetty.JettyHttpRequest;
import com.tracelytics.joboe.Context;
import com.tracelytics.joboe.Metadata;
import com.tracelytics.joboe.OboeException;
import com.tracelytics.joboe.config.ConfigManager;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.span.impl.Scope;
import com.tracelytics.joboe.span.impl.Span;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class JettyHttpRequestInstrumentation
extends ClassInstrumentation {
    private static String f = JettyHttpRequestInstrumentation.class.getName();
    private static String g = "jetty-http-client";
    private static List<MethodMatcher<a>> h = Arrays.asList(new MethodMatcher<a>("send", new String[0], "org.eclipse.jetty.client.api.ContentResponse", com.tracelytics.instrumentation.http.jetty.JettyHttpRequestInstrumentation$a.a, true), new MethodMatcher<a>("send", new String[]{"org.eclipse.jetty.client.api.Response$CompleteListener"}, "void", com.tracelytics.instrumentation.http.jetty.JettyHttpRequestInstrumentation$a.b, true));
    private static boolean i = ConfigManager.getConfig(ConfigProperty.AGENT_HIDE_PARAMS) != null ? ((HideParamsConfig)ConfigManager.getConfig(ConfigProperty.AGENT_HIDE_PARAMS)).shouldHideParams(Module.JETTY_HTTP_CLIENT) : false;

    public boolean applyInstrumentation(g g2, String object, byte[] object2) throws Exception {
        Object object3;
        object = this.a(g2, h).entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            object2 = entry;
            object3 = (l)entry.getKey();
            if ((object2 = (a)((Object)object2.getValue())) == com.tracelytics.instrumentation.http.jetty.JettyHttpRequestInstrumentation$a.a) {
                JettyHttpRequestInstrumentation.insertBefore((f)object3, f + ".beforeSyncSend(this);", false);
                JettyHttpRequestInstrumentation.addErrorReporting((f)object3, Exception.class.getName(), g, this.d);
                JettyHttpRequestInstrumentation.insertAfter((f)object3, f + ".afterSyncSend($_ != null ? Integer.valueOf($_.getStatus()) : null, $_ != null ? $_.getHeaders().get(\"X-Trace" + "\") : null);", true);
                continue;
            }
            if (object2 != com.tracelytics.instrumentation.http.jetty.JettyHttpRequestInstrumentation$a.b) continue;
            JettyHttpRequestInstrumentation.insertBefore((f)object3, f + ".beforeAsyncSend(this, $1);", false);
        }
        object3 = object = g2;
        object2 = "public void tvHeader(String key, String value) { header(key, value); }";
        ((g)object).a(o.a("public void tvHeader(String key, String value) { header(key, value); }", (g)object3, null, null));
        try {
            ((g)object).a("getMethod", "()Ljava/lang/String;");
            object3 = object;
            object2 = "public String tvGetMethod() { return getMethod(); }";
            ((g)object).a(o.a("public String tvGetMethod() { return getMethod(); }", (g)object3, null, null));
        }
        catch (t t2) {
            try {
                ((g)object).a("getMethod", "()Lorg/eclipse/jetty/http/HttpMethod;");
                object3 = object;
                object2 = "public String tvGetMethod() { return getMethod().toString(); }";
                ((g)object).a(o.a("public String tvGetMethod() { return getMethod().toString(); }", (g)object3, null, null));
            }
            catch (t t3) {
                a.warn("Failed to find proper getMethod method in " + ((g)object).o());
                object3 = object;
                object2 = "public String tvGetMethod() { return null; }";
                ((g)object).a(o.a("public String tvGetMethod() { return null; }", (g)object3, null, null));
            }
        }
        this.a(g2, JettyHttpRequest.class.getName());
        return true;
    }

    public static void beforeSyncSend(Object object) {
        object = (JettyHttpRequest)object;
        Object object2 = Context.getMetadata();
        if (((Metadata)object2).isSampled()) {
            object2 = JettyHttpRequestInstrumentation.buildTraceEventSpan(g).startActive(true);
            ((Scope)object2).span().setTag("IsService", true).setTag("Spec", "rsc").setTag("RemoteURL", JettyHttpRequestInstrumentation.a(object.getURI())).setTag("HTTPMethod", object.tvGetMethod());
            JettyHttpRequestInstrumentation.addBackTrace(((Scope)object2).span(), 1, Module.JETTY_HTTP_CLIENT);
            object2 = ((Scope)object2).span().context().getMetadata();
        }
        if (((Metadata)object2).isValid()) {
            object.tvHeader("X-Trace", ((Metadata)object2).toHexString());
        }
    }

    private static String a(URI uRI) {
        if (i) {
            try {
                return new URI(uRI.getScheme(), uRI.getAuthority(), uRI.getPath(), null, uRI.getFragment()).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                return uRI.toString();
            }
        }
        return uRI.toString();
    }

    public static void afterSyncSend(Integer object, String string) {
        Scope scope = c.active();
        if (scope != null && g.equals(scope.span().getOperationName())) {
            Span span = scope.span();
            if (object != null) {
                span.setTag("HTTPStatus", (Number)object);
            }
            if (string != null) {
                try {
                    object = new Metadata(string);
                    if (((Metadata)object).isTaskEqual(Context.getMetadata())) {
                        span.setSpanPropertyValue(Span.SpanProperty.CHILD_EDGES, Collections.singleton(string));
                    }
                }
                catch (OboeException oboeException) {
                    a.debug("Found invalid response x-trace ID from jetty http instrumentation : [" + string + "]");
                }
            }
            scope.close();
        }
    }

    public static void beforeAsyncSend(Object object, Object object2) {
        object = (JettyHttpRequest)object;
        Object object3 = Context.getMetadata();
        if (((Metadata)object3).isSampled()) {
            if (object2 instanceof SpanAware) {
                object2 = (SpanAware)object2;
                object3 = JettyHttpRequestInstrumentation.buildTraceEventSpan(g).start();
                ((Span)object3).setTag("IsService", true).setTag("Spec", "rsc").setTag("RemoteURL", JettyHttpRequestInstrumentation.a(object.getURI())).setTag("HTTPMethod", object.tvGetMethod());
                JettyHttpRequestInstrumentation.addBackTrace((Span)object3, 1, Module.JETTY_HTTP_CLIENT);
                ((Span)object3).setSpanPropertyValue(Span.SpanProperty.IS_ASYNC, Boolean.TRUE);
                object2.tvSetSpan((Span)object3);
                object3 = ((Span)object3).context().getMetadata();
            } else {
                a.warn("Cannot instrument jetty http async request as listener object [" + object2 + "] is not properly tagged");
            }
        }
        if (((Metadata)object3).isValid()) {
            object.tvHeader("X-Trace", ((Metadata)object3).toHexString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum a {
        a,
        b;

    }
}

