/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.instrumentation;

import com.appoptics.ext.io.a.b;
import com.tracelytics.a.f.a;
import com.tracelytics.a.f.c.h;
import com.tracelytics.a.f.d;
import com.tracelytics.a.f.f;
import com.tracelytics.a.f.g;
import com.tracelytics.a.f.i;
import com.tracelytics.a.f.j;
import com.tracelytics.a.f.k;
import com.tracelytics.a.f.l;
import com.tracelytics.a.f.o;
import com.tracelytics.a.f.t;
import com.tracelytics.instrumentation.ConstructorMatcher;
import com.tracelytics.instrumentation.MethodMatcher;
import com.tracelytics.instrumentation.Module;
import com.tracelytics.instrumentation.SpanAware;
import com.tracelytics.instrumentation.TvContextObjectAware;
import com.tracelytics.joboe.Context;
import com.tracelytics.joboe.Event;
import com.tracelytics.joboe.Metadata;
import com.tracelytics.joboe.OboeException;
import com.tracelytics.joboe.TraceConfig;
import com.tracelytics.joboe.TraceDecision;
import com.tracelytics.joboe.TraceDecisionUtil;
import com.tracelytics.joboe.XTraceHeader;
import com.tracelytics.joboe.XTraceOption;
import com.tracelytics.joboe.XTraceOptions;
import com.tracelytics.joboe.config.ConfigContainer;
import com.tracelytics.joboe.config.ConfigGroup;
import com.tracelytics.joboe.config.ConfigManager;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.config.ProfilerSetting;
import com.tracelytics.joboe.span.impl.ActiveSpan;
import com.tracelytics.joboe.span.impl.BaseSpan;
import com.tracelytics.joboe.span.impl.InboundMetricMeasurementSpanReporter;
import com.tracelytics.joboe.span.impl.MetricHistogramSpanReporter;
import com.tracelytics.joboe.span.impl.ProfilingSpanReporter;
import com.tracelytics.joboe.span.impl.Scope;
import com.tracelytics.joboe.span.impl.ScopeManager;
import com.tracelytics.joboe.span.impl.Span;
import com.tracelytics.joboe.span.impl.SpanDictionary;
import com.tracelytics.joboe.span.impl.TraceDecisionParameters;
import com.tracelytics.joboe.span.impl.TraceEventSpanReporter;
import com.tracelytics.joboe.span.impl.Tracer;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import com.tracelytics.util.BackTraceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassInstrumentation {
    protected static final Logger a = LoggerFactory.getLogger();
    private static List<Module> f = Arrays.asList(Module.X_MEMCACHED, Module.PLAY, Module.SLING, Module.RABBIT_MQ, Module.KAFKA, Module.JMS);
    private static Set<Module> g;
    public static final Map<String, XTraceHeader> XTRACE_HTTP_HEADER_KEYS;
    private static final boolean h;
    public static final String X_SPAN_KEY = "x-tv-span";
    public static final String XTRACE_HEADER = "X-Trace";
    public static final String X_TRACE_OPTIONS_RESPONSE_KEY = "X-Trace-Options-Response";
    protected static final Tracer b;
    protected static final ScopeManager c;
    private static final String[] i;
    protected d d = null;
    protected String e = null;

    public boolean shouldInstrument(g g2, d d2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean apply(g g2, d object, String string, byte[] byArray) throws Exception {
        this.d = object;
        this.e = this.getLayerName(g2);
        object = g2;
        synchronized (object) {
            if (!g2.l()) {
                return this.applyInstrumentation(g2, string, byArray);
            }
            a.info("CtClass of [" + g2.o() + "] is frozen. It probably has been modified already, skipping bytecode modification on this instance");
            return true;
        }
    }

    protected abstract boolean applyInstrumentation(g var1, String var2, byte[] var3) throws Exception;

    public static void addErrorReporting(f f2, String string, String string2, d d2) throws t, a {
        ClassInstrumentation.addErrorReporting(f2, string, string2, d2, false);
    }

    public static void addErrorReporting(f f2, String object, String string, d d2, boolean bl) throws t, a {
        object = d2.c((String)object);
        if (string != null) {
            f2.a("{ com.tracelytics.instrumentation.ClassInstrumentation.reportError(\"" + string + "\", $e, " + bl + "); throw $e; }", (g)object);
            return;
        }
        f2.a("{ com.tracelytics.instrumentation.ClassInstrumentation.reportError(null, $e, " + bl + "); throw $e; }", (g)object);
    }

    public static void reportError(String string, Throwable throwable) {
        ClassInstrumentation.reportError(string, throwable, false);
    }

    public static void reportError(String string, Throwable throwable, boolean bl) {
        Object object;
        if (Context.getMetadata().isSampled()) {
            object = Context.createEvent();
            String string2 = throwable.getMessage() != null ? throwable.getMessage() : "";
            ((Event)object).addInfo("Label", "error", "Spec", "error", "ErrorClass", throwable.getClass().getName(), "ErrorMsg", string2);
            if (string != null) {
                ((Event)object).addInfo("Layer", (Object)string);
            }
            ClassInstrumentation.addBackTrace((Event)object, throwable.getStackTrace());
            ((Event)object).report();
        }
        if (Context.getMetadata().isValid() && bl && (object = ScopeManager.INSTANCE.activeSpan()) != null) {
            ((Span)object).setTracePropertyValue(Span.TraceProperty.HAS_ERROR, Boolean.TRUE);
        }
    }

    public static void reportError(Span span, Throwable throwable) {
        ClassInstrumentation.reportError(span, throwable, null);
    }

    public static void reportError(Span span, Throwable throwable, String string) {
        if (string == null && throwable != null) {
            string = throwable.getMessage() != null ? throwable.getMessage() : "";
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (throwable != null) {
            hashMap.put("ErrorClass", throwable.getClass().getName());
            hashMap.put("Backtrace", BackTraceUtil.backTraceToString(throwable.getStackTrace()));
        }
        if (string != null) {
            hashMap.put("ErrorMsg", string);
        }
        hashMap.put("Spec", "error");
        span.error(hashMap);
    }

    public static void reportError(Span span, String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null) {
            hashMap.put("ErrorClass", string);
        }
        if (string2 != null) {
            hashMap.put("ErrorMsg", string2);
        }
        hashMap.put("Spec", "error");
        span.error(hashMap);
    }

    public static void addBackTrace(Event event, int n2) {
        ClassInstrumentation.addBackTrace(event, n2, Module.SDK);
    }

    public static void addBackTrace(Event event, int n2, Module module) {
        if (module != null && !g.contains((Object)module)) {
            a.debug("Skipping back trace as module " + module.toString() + " is not included in modules configured for back trace reporting");
            return;
        }
        ClassInstrumentation.addBackTrace(event, BackTraceUtil.getBackTrace(n2 + 1));
    }

    public static void addBackTrace(Span span, int n2, Module module) {
        if (module != null && !g.contains((Object)module)) {
            a.debug("Skipping back trace as module " + module.toString() + " is not included in modules configured for back trace reporting");
            return;
        }
        ClassInstrumentation.addBackTrace(span, BackTraceUtil.getBackTrace(n2 + 1));
    }

    public static void addBackTrace(Event event, StackTraceElement[] stackTraceElementArray) {
        event.addInfo("Backtrace", (Object)BackTraceUtil.backTraceToString(stackTraceElementArray));
    }

    public static void addBackTrace(Span span, StackTraceElement[] stackTraceElementArray) {
        span.setTag("Backtrace", BackTraceUtil.backTraceToString(stackTraceElementArray));
    }

    public static void addBackTrace(BaseSpan baseSpan, StackTraceElement[] stackTraceElementArray) {
        ClassInstrumentation.addBackTrace(((ActiveSpan)baseSpan).getWrapped().span(), stackTraceElementArray);
    }

    @Deprecated
    public static StackTraceElement[] getBackTrace(int n2) {
        return BackTraceUtil.getBackTrace(n2);
    }

    protected String getLayerName(g g2) {
        return (String)ConfigManager.getConfig(ConfigProperty.AGENT_LAYER);
    }

    public static boolean shouldModify(g g2, f f2) {
        return f2.e() == g2 && !com.appoptics.ext.io.a.b.f(f2.c());
    }

    protected static boolean a(g g2, String string, String string2) {
        boolean bl;
        try {
            g2.a(string, string2);
            bl = true;
        }
        catch (t t2) {
            bl = false;
        }
        return bl;
    }

    protected final boolean a(g g2, String object) throws t {
        object = this.d.d((String)object);
        for (g g3 : g2.d()) {
            if (!g3.equals(object)) continue;
            return false;
        }
        g2.c((g)object);
        return true;
    }

    protected final void a(g g2) throws a, t {
        String string = Metadata.class.getName();
        Object object = j.a("private " + string + " tvContextObject;", g2);
        Object object2 = g2;
        ((g)object2).a((j)object, (j.c)null);
        object = g2;
        object2 = "public void setTvContext(" + string + " metadata) { tvContextObject = metadata; }";
        g2.a(o.a((String)object2, (g)object, null, null));
        object = g2;
        object2 = "public " + string + " getTvContext() { return tvContextObject; }";
        g2.a(o.a((String)object2, (g)object, null, null));
        object = j.a("private " + string + " tvClonedContext;", g2);
        object2 = g2;
        ((g)object2).a((j)object, (j.c)null);
        object = g2;
        object2 = "public void tvSetClonedContext(" + string + " metadata) { tvClonedContext = metadata; }";
        g2.a(o.a((String)object2, (g)object, null, null));
        object = g2;
        object2 = "public " + string + " tvGetClonedContext() { return tvClonedContext; }";
        g2.a(o.a((String)object2, (g)object, null, null));
        object = j.a("private " + string + " tvPreviousContextObject;", g2);
        object2 = g2;
        ((g)object2).a((j)object, (j.c)null);
        object = g2;
        object2 = "public void setTvPreviousContext(" + string + " metadata) { tvPreviousContextObject = metadata; }";
        g2.a(o.a((String)object2, (g)object, null, null));
        object = g2;
        object2 = "public " + string + " getTvPreviousContext() { return tvPreviousContextObject; }";
        g2.a(o.a((String)object2, (g)object, null, null));
        if (!ClassInstrumentation.b(g2, "tvFromThreadId")) {
            object = j.a("private long tvFromThreadId;", g2);
            object2 = g2;
            ((g)object2).a((j)object, (j.c)null);
        }
        object = g2;
        object2 = "public void setTvFromThreadId(long threadId) { tvFromThreadId = threadId; }";
        g2.a(o.a("public void setTvFromThreadId(long threadId) { tvFromThreadId = threadId; }", (g)object, null, null));
        object = g2;
        object2 = "public long getTvFromThreadId() { return tvFromThreadId; }";
        g2.a(o.a("public long getTvFromThreadId() { return tvFromThreadId; }", (g)object, null, null));
        object = j.a("private boolean tvRestored;", g2);
        object2 = g2;
        ((g)object2).a((j)object, (j.c)null);
        object = g2;
        object2 = "public void setTvRestored(boolean restored) { tvRestored = restored; }";
        g2.a(o.a("public void setTvRestored(boolean restored) { tvRestored = restored; }", (g)object, null, null));
        object = g2;
        object2 = "public boolean tvRestored() { return tvRestored; }";
        g2.a(o.a("public boolean tvRestored() { return tvRestored; }", (g)object, null, null));
        this.a(g2, TvContextObjectAware.class.getName());
    }

    private static boolean b(g g2, String string) {
        try {
            g2.b(string);
            return true;
        }
        catch (t t2) {
            return false;
        }
    }

    protected final boolean b(g g2) throws a, t {
        String string = Span.class.getName();
        boolean bl = g2.a(this.d.c(SpanAware.class.getName()));
        if (!bl) {
            Object object = j.a("private " + string + " tvSpan;", g2);
            Object object2 = g2;
            ((g)object2).a((j)object, (j.c)null);
            object = g2;
            object2 = "public void tvSetSpan(" + string + " span) {     tvSpan = span; }";
            g2.a(o.a((String)object2, (g)object, null, null));
            object = g2;
            object2 = "public " + string + " tvGetSpan() { return tvSpan; }";
            g2.a(o.a((String)object2, (g)object, null, null));
            this.a(g2, SpanAware.class.getName());
            return true;
        }
        return false;
    }

    public static void insertBefore(f f2, String string) throws a {
        ClassInstrumentation.insertBefore(f2, string, true);
    }

    public static void insertBefore(f f2, String string, boolean bl) throws a {
        if (bl) {
            string = ClassInstrumentation.a(string);
        }
        string = ClassInstrumentation.b(string);
        f2.a(string);
    }

    public static void insertAfter(f f2, String string) throws a {
        ClassInstrumentation.insertAfter(f2, string, false);
    }

    public static void insertAfter(f f2, String string, boolean bl) throws a {
        ClassInstrumentation.insertAfter(f2, string, bl, true);
    }

    public static void insertAfter(f f2, String string, boolean bl, boolean bl2) throws a {
        if (bl2) {
            string = ClassInstrumentation.a(string);
        }
        string = ClassInstrumentation.b(string);
        f2.a(string, bl);
    }

    protected static void a(h h2, String string) throws a {
        ClassInstrumentation.a(h2, string, true);
    }

    protected static void a(h h2, String string, boolean bl) throws a {
        if (bl) {
            string = ClassInstrumentation.a(string);
        }
        string = "{" + string + " $_ = $proceed($$); }";
        h2.a(string);
    }

    protected static void b(h h2, String string, boolean bl) throws a {
        if (bl) {
            string = ClassInstrumentation.a(string);
        }
        string = "{ $_ = $proceed($$); " + string + "}";
        h2.a(string);
    }

    private static String a(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = Context.class.getName();
        stringBuffer.append("if (" + string2 + ".getMetadata().isSampled()) {");
        stringBuffer.append(string);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    protected static String b(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("try {");
        stringBuffer.append(string);
        stringBuffer.append("} catch (Throwable e) {");
        stringBuffer.append("    try { ");
        stringBuffer.append(ClassInstrumentation.class.getName() + ".logThrowable(e);");
        stringBuffer.append("    } catch (Throwable e) {");
        stringBuffer.append("        System.err.println(\"[[AppOptics]] Caught exception as below. Please take note that existing code flow should not be affected, this might only impact the instrumentation of current trace\"); ");
        stringBuffer.append("        System.err.println(e.getMessage()); ");
        stringBuffer.append("        e.printStackTrace(); ");
        stringBuffer.append("    }");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static void logThrowable(Throwable throwable) {
        a.warn("Caught exception as below. Please take note that existing code flow should not be affected, this might only impact the instrumentation of current trace");
        a.warn(throwable.getMessage(), throwable);
    }

    public static Event startTrace(String object, Map<XTraceHeader, String> object2, String string) {
        Object object3 = Context.getMetadata();
        String string2 = object2.get((Object)XTraceHeader.TRACE_ID);
        if (string2 != null && !Metadata.isCompatible(string2)) {
            a.debug("Not accepting X-Trace ID [" + string2 + "] for trace continuation");
            string2 = null;
        }
        object2 = XTraceOptions.getXTraceOptions(object2.get((Object)XTraceHeader.TRACE_OPTIONS), object2.get((Object)XTraceHeader.TRACE_OPTIONS_SIGNATURE));
        object = TraceDecisionUtil.shouldTraceRequest((String)object, string2, (XTraceOptions)object2, string);
        boolean bl = false;
        if (((TraceDecision)object).isSampled()) {
            if (string2 != null) {
                a.debug("Continuing trace: " + string2);
                try {
                    ((Metadata)object3).fromHexString(string2);
                }
                catch (OboeException oboeException) {
                    a.debug("Invalid X-Trace header received: " + string2);
                }
            } else {
                bl = true;
                a.debug("Starting new trace");
                ((Metadata)object3).randomize(true);
            }
        } else if (string2 != null) {
            a.debug("Propagation but not continuting trace: " + string2);
            try {
                ((Metadata)object3).fromHexString(string2);
                ((Metadata)object3).setSampled(false);
            }
            catch (OboeException oboeException) {
                a.debug("Invalid X-Trace header received: " + string2);
            }
        } else {
            ((Metadata)object3).randomize(false);
        }
        ((Metadata)object3).setReportMetrics(((TraceDecision)object).isReportMetrics());
        if (((Metadata)object3).isSampled()) {
            object3 = Context.createEventWithContext((Metadata)object3, !bl);
            if (bl && ((TraceDecision)object).getTraceConfig() != null) {
                Object object4 = ((TraceDecision)object).getTraceConfig();
                ((Event)object3).addInfo("SampleRate", (Object)(((TraceDecisionUtil.RequestType)((Object)(object = ((TraceDecision)object).getRequestType()))).isTriggerTrace() ? -1 : ((TraceConfig)object4).getSampleRate()));
                ((Event)object3).addInfo("SampleSource", (Object)(((TraceDecisionUtil.RequestType)((Object)object)).isTriggerTrace() ? -1 : ((TraceConfig)object4).getSampleRateSourceValue()));
                ((Event)object3).addInfo("BucketCapacity", (Object)((TraceConfig)object4).getBucketCapacity(((TraceDecisionUtil.RequestType)((Object)object)).getBucketType()));
                ((Event)object3).addInfo("BucketRate", (Object)((TraceConfig)object4).getBucketRate(((TraceDecisionUtil.RequestType)((Object)object)).getBucketType()));
                if (object2 != null) {
                    if (((TraceDecisionUtil.RequestType)((Object)object)).isTriggerTrace()) {
                        ((Event)object3).addInfo("TriggeredTrace", (Object)Boolean.TRUE);
                    }
                    if ((object = ((XTraceOptions)object2).getCustomKvs()) != null) {
                        object = object.entrySet().iterator();
                        while (object.hasNext()) {
                            object4 = (Map.Entry)object.next();
                            ((Event)object3).addInfo(((XTraceOption)object4.getKey()).getKey(), object4.getValue());
                        }
                    }
                    if ((object = ((XTraceOptions)object2).getOptionValue(XTraceOption.PD_KEYS)) != null) {
                        ((Event)object3).addInfo("PDKeys", object);
                    }
                }
            }
            return object3;
        }
        return null;
    }

    public static Span startTraceAsSpan(String object, Map<XTraceHeader, String> map, String string, boolean bl) {
        object = ClassInstrumentation.getStartTraceSpanBuilder((String)object, map, string, bl);
        return ((Tracer.SpanBuilder)object).start();
    }

    public static void setForwardedTags(Span span, HeaderExtractor<String, String> headerExtractor) {
        String[] stringArray = i;
        for (int i2 = 0; i2 < 4; ++i2) {
            String string = stringArray[i2];
            String string2 = "x-" + string.toLowerCase();
            if ((string2 = headerExtractor.extract(string2)) == null) continue;
            span.setTag(string, string2);
        }
    }

    public static ActiveSpan startTraceAsSpan(String object, Map<XTraceHeader, String> map, String string, Map<String, Object> map2) {
        object = ClassInstrumentation.getStartTraceSpanBuilder((String)object, map, string, true);
        if (map2 != null && !map2.isEmpty()) {
            ((Tracer.SpanBuilder)object).withTags(map2);
        }
        return new ActiveSpan(((Tracer.SpanBuilder)object).startActive());
    }

    public static Scope startTraceAsScope(String object, Map<XTraceHeader, String> map, String string, boolean bl) {
        object = ClassInstrumentation.getStartTraceSpanBuilder((String)object, map, string, bl);
        return ((Tracer.SpanBuilder)object).startActive();
    }

    public static Scope startTraceAsScope(String object, Map<XTraceHeader, String> map, String string, Map<String, Object> map2, boolean bl) {
        object = ClassInstrumentation.getStartTraceSpanBuilder((String)object, map, string, bl);
        if (map2 != null && !map2.isEmpty()) {
            ((Tracer.SpanBuilder)object).withTags(map2);
        }
        return ((Tracer.SpanBuilder)object).startActive();
    }

    public static Tracer.SpanBuilder getStartTraceSpanBuilder(String string, Map<XTraceHeader, String> map, String string2) {
        return ClassInstrumentation.getStartTraceSpanBuilder(string, map, string2, true);
    }

    public static Tracer.SpanBuilder getStartTraceSpanBuilder(String object, Map<XTraceHeader, String> object2, String object3, boolean bl) {
        object = Tracer.INSTANCE.buildSpan((String)object).withReporters(TraceEventSpanReporter.REPORTER, InboundMetricMeasurementSpanReporter.REPORTER, MetricHistogramSpanReporter.REPORTER);
        if (h && bl) {
            object = ((Tracer.SpanBuilder)object).withReporters(ProfilingSpanReporter.REPORTER);
        }
        object = ((Tracer.SpanBuilder)object).withSpanProperty(Span.SpanProperty.TRACE_DECISION_PARAMETERS, new TraceDecisionParameters((Map<XTraceHeader, String>)object2, (String)object3));
        if (object2.containsKey((Object)XTraceHeader.SPAN_ID)) {
            object2 = object2.get((Object)XTraceHeader.SPAN_ID);
            try {
                object3 = SpanDictionary.getSpan(Long.parseLong((String)object2));
                if (object3 != null) {
                    object = ((Tracer.SpanBuilder)object).asChildOf((com.tracelytics.joboe.span.Span)object3);
                } else {
                    a.debug("Do not continue with span id [" + (String)object2 + "] as such a span is not found in the current process");
                }
            }
            catch (NumberFormatException numberFormatException) {
                a.warn("Failed to continue on with span id [" + (String)object2 + "] as the id is not a valid long");
            }
        }
        return object;
    }

    public static Tracer.SpanBuilder buildTraceEventSpan(String string) {
        return b.buildSpan(string).withReporters(TraceEventSpanReporter.REPORTER);
    }

    protected final <T> Map<l, T> a(g g2, List<MethodMatcher<T>> list) {
        return this.a(g2.y(), list);
    }

    protected final <T> Map<i, T> b(g g2, List<ConstructorMatcher<T>> list) {
        return this.a(g2.w(), list);
    }

    private <T, B extends f, M extends MethodMatcher<T>> Map<B, T> a(B[] BArray, List<M> list) {
        Map<String, List<M>> map = ClassInstrumentation.a(list);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        block0: for (B b2 : BArray) {
            List<M> list2;
            if (com.appoptics.ext.io.a.b.f(((f)b2).c()) || (list2 = b2 instanceof i ? list : map.get(((k)b2).j())) == null) continue;
            list2 = list2.iterator();
            while (list2.hasNext()) {
                MethodMatcher methodMatcher = (MethodMatcher)list2.next();
                if (!methodMatcher.matches((f)b2, this.d)) continue;
                linkedHashMap.put(b2, methodMatcher.getInstType());
                continue block0;
            }
        }
        return linkedHashMap;
    }

    private static <I, M extends MethodMatcher<I>> Map<String, List<M>> a(List<M> object) {
        HashMap<String, List<M>> hashMap = new HashMap<String, List<M>>();
        object = object.iterator();
        while (object.hasNext()) {
            List<MethodMatcher> list;
            MethodMatcher methodMatcher = (MethodMatcher)object.next();
            if (!hashMap.containsKey(methodMatcher.getMethodName())) {
                list = new ArrayList();
                hashMap.put(methodMatcher.getMethodName(), list);
            } else {
                list = (List)hashMap.get(methodMatcher.getMethodName());
            }
            list.add(methodMatcher);
        }
        return hashMap;
    }

    public static Map<XTraceHeader, String> extractXTraceHeaders(HeaderExtractor<String, String> headerExtractor) {
        HashMap<XTraceHeader, String> hashMap = new HashMap<XTraceHeader, String>();
        for (Map.Entry<String, XTraceHeader> entry : XTRACE_HTTP_HEADER_KEYS.entrySet()) {
            String string = headerExtractor.extract(entry.getKey());
            if (string == null) continue;
            hashMap.put(entry.getValue(), string);
        }
        return hashMap;
    }

    static {
        XTRACE_HTTP_HEADER_KEYS = new HashMap<String, XTraceHeader>();
        h = ConfigManager.getConfig(ConfigProperty.PROFILER) != null && ((ProfilerSetting)ConfigManager.getConfig(ConfigProperty.PROFILER)).isEnabled();
        b = Tracer.INSTANCE;
        c = ScopeManager.INSTANCE;
        i = new String[]{"Forwarded-For", "Forwarded-Host", "Forwarded-Proto", "Forwarded-Port"};
        Object object = ConfigManager.getConfigs(ConfigGroup.AGENT);
        HashSet<Module> hashSet = new HashSet<Module>();
        Object object2 = (Boolean)((ConfigContainer)object).get(ConfigProperty.AGENT_EXTENDED_BACK_TRACES);
        if (object2 != null && ((Boolean)object2).booleanValue()) {
            hashSet.addAll(f);
        } else {
            object2 = (List)((ConfigContainer)object).get(ConfigProperty.AGENT_EXTENDED_BACK_TRACES_BY_MODULE);
            if (object2 != null) {
                hashSet.addAll((Collection<Module>)object2);
            }
        }
        object2 = (List)((ConfigContainer)object).get(ConfigProperty.AGENT_BACKTRACE_MODULES);
        if (object2 != null) {
            hashSet.addAll((Collection<Module>)object2);
        } else {
            object = new ArrayList<Module>(Arrays.asList(Module.values()));
            object.removeAll(f);
            hashSet.addAll((Collection<Module>)object);
        }
        if (hashSet.isEmpty()) {
            a.info("Not reporting any back traces based on configuration");
        }
        g = hashSet;
        XTRACE_HTTP_HEADER_KEYS.put(XTRACE_HEADER, XTraceHeader.TRACE_ID);
        XTRACE_HTTP_HEADER_KEYS.put(X_SPAN_KEY, XTraceHeader.SPAN_ID);
        XTRACE_HTTP_HEADER_KEYS.put("X-Trace-Options", XTraceHeader.TRACE_OPTIONS);
        XTRACE_HTTP_HEADER_KEYS.put("X-Trace-Options-Signature", XTraceHeader.TRACE_OPTIONS_SIGNATURE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface HeaderExtractor<T, R> {
        public R extract(T var1);
    }
}

