/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal.shaded.org.jctools.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class UnsafeAccess {
    public static final boolean SUPPORTS_GET_AND_SET_REF;
    public static final boolean SUPPORTS_GET_AND_ADD_LONG;
    public static final Unsafe UNSAFE;

    private static Unsafe getUnsafe() {
        Object object;
        try {
            object = Unsafe.class.getDeclaredField("theUnsafe");
            ((Field)object).setAccessible(true);
            object = (Unsafe)((Field)object).get(null);
        }
        catch (Exception exception) {
            try {
                object = Unsafe.class.getDeclaredConstructor(new Class[0]);
                ((Constructor)object).setAccessible(true);
                object = (Unsafe)((Constructor)object).newInstance(new Object[0]);
            }
            catch (Exception exception2) {
                throw new RuntimeException(exception2);
            }
        }
        return object;
    }

    private static boolean hasGetAndSetSupport() {
        try {
            Unsafe.class.getMethod("getAndSetObject", Object.class, Long.TYPE, Object.class);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean hasGetAndAddLongSupport() {
        try {
            Unsafe.class.getMethod("getAndAddLong", Object.class, Long.TYPE, Long.TYPE);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static long fieldOffset(Class clazz, String string) throws RuntimeException {
        try {
            return UNSAFE.objectFieldOffset(clazz.getDeclaredField(string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
    }

    static {
        UNSAFE = UnsafeAccess.getUnsafe();
        SUPPORTS_GET_AND_SET_REF = UnsafeAccess.hasGetAndSetSupport();
        SUPPORTS_GET_AND_ADD_LONG = UnsafeAccess.hasGetAndAddLongSupport();
    }
}

