/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal.logging;

import com.appoptics.ext.io.netty.util.internal.logging.InternalLogLevel;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.org.apache.logging.log4j.Level;
import com.appoptics.ext.org.apache.logging.log4j.Logger;
import com.appoptics.ext.org.apache.logging.log4j.spi.ExtendedLogger;
import com.appoptics.ext.org.apache.logging.log4j.spi.ExtendedLoggerWrapper;
import java.security.AccessController;
import java.security.PrivilegedAction;

class Log4J2Logger
extends ExtendedLoggerWrapper
implements InternalLogger {
    private static final boolean VARARGS_ONLY = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public final Boolean run() {
            try {
                Logger.class.getMethod("debug", String.class, Object.class);
                return Boolean.FALSE;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return Boolean.TRUE;
            }
            catch (SecurityException securityException) {
                return Boolean.FALSE;
            }
        }
    });

    Log4J2Logger(Logger logger) {
        super((ExtendedLogger)logger, logger.getName(), logger.getMessageFactory());
        if (VARARGS_ONLY) {
            throw new UnsupportedOperationException("Log4J2 version mismatch");
        }
    }

    public boolean isEnabled(InternalLogLevel internalLogLevel) {
        return this.isEnabled(Log4J2Logger.toLevel(internalLogLevel));
    }

    public void log(InternalLogLevel internalLogLevel, String string, Object object, Object object2) {
        this.log(Log4J2Logger.toLevel(internalLogLevel), string, object, object2);
    }

    public void log(InternalLogLevel internalLogLevel, String string, Object ... objectArray) {
        this.log(Log4J2Logger.toLevel(internalLogLevel), string, objectArray);
    }

    private static Level toLevel(InternalLogLevel internalLogLevel) {
        switch (internalLogLevel) {
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case TRACE: {
                return Level.TRACE;
            }
        }
        throw new Error();
    }
}

