/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal;

import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThrowableUtil {
    public static <T extends Throwable> T unknownStackTrace(T t2, Class<?> clazz, String string) {
        t2.setStackTrace(new StackTraceElement[]{new StackTraceElement(clazz.getName(), string, null, -1)});
        return t2;
    }

    public static String stackTraceToString(Throwable object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        ((Throwable)object).printStackTrace(printStream);
        printStream.flush();
        try {
            object = new String(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {}
        return object;
    }

    public static boolean haveSuppressed() {
        return PlatformDependent.javaVersion() >= 7;
    }

    public static void addSuppressed(Throwable throwable, Throwable throwable2) {
        if (!ThrowableUtil.haveSuppressed()) {
            return;
        }
        throwable.addSuppressed(throwable2);
    }

    public static void addSuppressedAndClear(Throwable throwable, List<Throwable> list) {
        ThrowableUtil.addSuppressed(throwable, list);
        list.clear();
    }

    public static void addSuppressed(Throwable throwable, List<Throwable> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Throwable throwable2 = (Throwable)object.next();
            ThrowableUtil.addSuppressed(throwable, throwable2);
        }
    }
}

