/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SocketUtils {
    private static final Enumeration<Object> EMPTY = Collections.enumeration(Collections.emptyList());

    private static <T> Enumeration<T> empty() {
        return EMPTY;
    }

    public static void bind(Socket object, SocketAddress socketAddress) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>((Socket)object, socketAddress){
                final /* synthetic */ Socket val$socket;
                final /* synthetic */ SocketAddress val$bindpoint;
                {
                    this.val$socket = socket;
                    this.val$bindpoint = socketAddress;
                }

                @Override
                public final Void run() throws IOException {
                    this.val$socket.bind(this.val$bindpoint);
                    return null;
                }
            });
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException;
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static boolean connect(SocketChannel object, SocketAddress socketAddress) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>((SocketChannel)object, socketAddress){
                final /* synthetic */ SocketChannel val$socketChannel;
                final /* synthetic */ SocketAddress val$remoteAddress;
                {
                    this.val$socketChannel = socketChannel;
                    this.val$remoteAddress = socketAddress;
                }

                @Override
                public final Boolean run() throws IOException {
                    return this.val$socketChannel.connect(this.val$remoteAddress);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException;
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static void bind(SocketChannel object, SocketAddress socketAddress) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>((SocketChannel)object, socketAddress){
                final /* synthetic */ SocketChannel val$socketChannel;
                final /* synthetic */ SocketAddress val$address;
                {
                    this.val$socketChannel = socketChannel;
                    this.val$address = socketAddress;
                }

                @Override
                public final Void run() throws IOException {
                    this.val$socketChannel.bind(this.val$address);
                    return null;
                }
            });
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException;
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static SocketChannel accept(ServerSocketChannel object) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<SocketChannel>((ServerSocketChannel)object){
                final /* synthetic */ ServerSocketChannel val$serverSocketChannel;
                {
                    this.val$serverSocketChannel = serverSocketChannel;
                }

                @Override
                public final SocketChannel run() throws IOException {
                    return this.val$serverSocketChannel.accept();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException;
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static SocketAddress localSocketAddress(final ServerSocket serverSocket) {
        return AccessController.doPrivileged(new PrivilegedAction<SocketAddress>(){

            @Override
            public final SocketAddress run() {
                return serverSocket.getLocalSocketAddress();
            }
        });
    }

    public static Enumeration<InetAddress> addressesFromNetworkInterface(NetworkInterface object) {
        if ((object = AccessController.doPrivileged(new PrivilegedAction<Enumeration<InetAddress>>((NetworkInterface)object){
            final /* synthetic */ NetworkInterface val$intf;
            {
                this.val$intf = networkInterface;
            }

            @Override
            public final Enumeration<InetAddress> run() {
                return this.val$intf.getInetAddresses();
            }
        })) == null) {
            return SocketUtils.empty();
        }
        return object;
    }

    public static byte[] hardwareAddressFromNetworkInterface(NetworkInterface object) throws SocketException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>((NetworkInterface)object){
                final /* synthetic */ NetworkInterface val$intf;
                {
                    this.val$intf = networkInterface;
                }

                @Override
                public final byte[] run() throws SocketException {
                    return this.val$intf.getHardwareAddress();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException;
            throw (SocketException)privilegedActionException.getCause();
        }
    }
}

