/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal;

import com.appoptics.ext.io.netty.util.IllegalReferenceCountException;
import com.appoptics.ext.io.netty.util.ReferenceCounted;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferenceCountUpdater<T extends ReferenceCounted> {
    protected ReferenceCountUpdater() {
    }

    public static long getUnsafeOffset(Class<? extends ReferenceCounted> clazz, String string) {
        try {
            if (PlatformDependent.hasUnsafe()) {
                return PlatformDependent.objectFieldOffset(clazz.getDeclaredField(string));
            }
        }
        catch (Throwable throwable) {}
        return -1L;
    }

    protected abstract AtomicIntegerFieldUpdater<T> updater();

    protected abstract long unsafeOffset();

    public final int initialValue() {
        return 2;
    }

    private static int realRefCnt(int n2) {
        if (n2 != 2 && n2 != 4 && (n2 & 1) != 0) {
            return 0;
        }
        return n2 >>> 1;
    }

    private static int toLiveRealRefCnt(int n2, int n3) {
        if (n2 == 2 || n2 == 4 || (n2 & 1) == 0) {
            return n2 >>> 1;
        }
        throw new IllegalReferenceCountException(0, -n3);
    }

    private int nonVolatileRawCnt(T t2) {
        long l2 = this.unsafeOffset();
        if (l2 != -1L) {
            return PlatformDependent.getInt(t2, l2);
        }
        return this.updater().get(t2);
    }

    public final int refCnt(T t2) {
        return ReferenceCountUpdater.realRefCnt(this.updater().get(t2));
    }

    public final boolean isLiveNonVolatile(T t2) {
        long l2 = this.unsafeOffset();
        int n2 = l2 != -1L ? PlatformDependent.getInt(t2, l2) : this.updater().get(t2);
        return n2 == 2 || n2 == 4 || n2 == 6 || n2 == 8 || (n2 & 1) == 0;
    }

    public final void resetRefCnt(T t2) {
        this.updater().set(t2, this.initialValue());
    }

    public final T retain(T t2) {
        return this.retain0(t2, 1, 2);
    }

    private T retain0(T t2, int n2, int n3) {
        int n4 = this.updater().getAndAdd(t2, n3);
        if (n4 != 2 && n4 != 4 && (n4 & 1) != 0) {
            throw new IllegalReferenceCountException(0, n2);
        }
        if (n4 <= 0 && n4 + n3 >= 0 || n4 >= 0 && n4 + n3 < n4) {
            this.updater().getAndAdd(t2, -n3);
            throw new IllegalReferenceCountException(ReferenceCountUpdater.realRefCnt(n4), n2);
        }
        return t2;
    }

    public final boolean release(T t2) {
        int n2 = this.nonVolatileRawCnt(t2);
        if (n2 == 2) {
            return this.tryFinalRelease0(t2, 2) || this.retryRelease0(t2, 1);
        }
        int n3 = n2;
        return this.nonFinalRelease0(t2, 1, n3, ReferenceCountUpdater.toLiveRealRefCnt(n3, 1));
    }

    public final boolean release(T t2, int n2) {
        int n3 = this.nonVolatileRawCnt(t2);
        int n4 = ReferenceCountUpdater.toLiveRealRefCnt(n3, ObjectUtil.checkPositive(n2, "decrement"));
        if (n2 == n4) {
            return this.tryFinalRelease0(t2, n3) || this.retryRelease0(t2, n2);
        }
        return this.nonFinalRelease0(t2, n2, n3, n4);
    }

    private boolean tryFinalRelease0(T t2, int n2) {
        return this.updater().compareAndSet(t2, n2, 1);
    }

    private boolean nonFinalRelease0(T t2, int n2, int n3, int n4) {
        if (n2 < n4) {
            int n5 = n3;
            if (this.updater().compareAndSet(t2, n5, n5 - (n2 << 1))) {
                return false;
            }
        }
        return this.retryRelease0(t2, n2);
    }

    private boolean retryRelease0(T t2, int n2) {
        while (true) {
            int n3;
            int n4;
            if (n2 == (n4 = ReferenceCountUpdater.toLiveRealRefCnt(n3 = this.updater().get(t2), n2))) {
                if (this.tryFinalRelease0(t2, n3)) {
                    return true;
                }
            } else if (n2 < n4) {
                int n5 = n3;
                if (this.updater().compareAndSet(t2, n5, n5 - (n2 << 1))) {
                    return false;
                }
            } else {
                throw new IllegalReferenceCountException(n4, -n2);
            }
            Thread.yield();
        }
    }
}

