/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal;

import com.appoptics.ext.io.netty.util.concurrent.FastThreadLocalThread;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.ThreadLocalRandom;
import com.appoptics.ext.io.netty.util.internal.TypeParameterMatcher;
import com.appoptics.ext.io.netty.util.internal.UnpaddedInternalThreadLocalMap;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InternalThreadLocalMap
extends UnpaddedInternalThreadLocalMap {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(InternalThreadLocalMap.class);
    private static final int STRING_BUILDER_INITIAL_SIZE;
    private static final int STRING_BUILDER_MAX_SIZE;
    public static final Object UNSET;

    public static InternalThreadLocalMap getIfSet() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            return ((FastThreadLocalThread)thread).threadLocalMap();
        }
        return (InternalThreadLocalMap)slowThreadLocalMap.get();
    }

    public static InternalThreadLocalMap get() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            return InternalThreadLocalMap.fastGet((FastThreadLocalThread)thread);
        }
        return InternalThreadLocalMap.slowGet();
    }

    private static InternalThreadLocalMap fastGet(FastThreadLocalThread fastThreadLocalThread) {
        InternalThreadLocalMap internalThreadLocalMap = fastThreadLocalThread.threadLocalMap();
        if (internalThreadLocalMap == null) {
            internalThreadLocalMap = new InternalThreadLocalMap();
            fastThreadLocalThread.setThreadLocalMap(internalThreadLocalMap);
        }
        return internalThreadLocalMap;
    }

    private static InternalThreadLocalMap slowGet() {
        ThreadLocal<InternalThreadLocalMap> threadLocal = UnpaddedInternalThreadLocalMap.slowThreadLocalMap;
        InternalThreadLocalMap internalThreadLocalMap = threadLocal.get();
        if (internalThreadLocalMap == null) {
            internalThreadLocalMap = new InternalThreadLocalMap();
            threadLocal.set(internalThreadLocalMap);
        }
        return internalThreadLocalMap;
    }

    public static void remove() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            ((FastThreadLocalThread)thread).setThreadLocalMap(null);
            return;
        }
        slowThreadLocalMap.remove();
    }

    public static int nextVariableIndex() {
        int n2 = nextIndex.getAndIncrement();
        if (n2 < 0) {
            nextIndex.decrementAndGet();
            throw new IllegalStateException("too many thread-local indexed variables");
        }
        return n2;
    }

    private InternalThreadLocalMap() {
        super(InternalThreadLocalMap.newIndexedVariableTable());
    }

    private static Object[] newIndexedVariableTable() {
        Object[] objectArray = new Object[32];
        Arrays.fill(objectArray, UNSET);
        return objectArray;
    }

    public final StringBuilder stringBuilder() {
        StringBuilder stringBuilder = this.stringBuilder;
        if (stringBuilder == null) {
            this.stringBuilder = new StringBuilder(STRING_BUILDER_INITIAL_SIZE);
            return this.stringBuilder;
        }
        if (stringBuilder.capacity() > STRING_BUILDER_MAX_SIZE) {
            stringBuilder.setLength(STRING_BUILDER_INITIAL_SIZE);
            stringBuilder.trimToSize();
        }
        stringBuilder.setLength(0);
        return stringBuilder;
    }

    public final Map<Charset, CharsetEncoder> charsetEncoderCache() {
        IdentityHashMap identityHashMap = this.charsetEncoderCache;
        if (identityHashMap == null) {
            this.charsetEncoderCache = identityHashMap = new IdentityHashMap();
        }
        return identityHashMap;
    }

    public final int futureListenerStackDepth() {
        return this.futureListenerStackDepth;
    }

    public final void setFutureListenerStackDepth(int n2) {
        this.futureListenerStackDepth = n2;
    }

    public final ThreadLocalRandom random() {
        ThreadLocalRandom threadLocalRandom = this.random;
        if (threadLocalRandom == null) {
            this.random = threadLocalRandom = new ThreadLocalRandom();
        }
        return threadLocalRandom;
    }

    public final Map<Class<?>, TypeParameterMatcher> typeParameterMatcherGetCache() {
        IdentityHashMap identityHashMap = this.typeParameterMatcherGetCache;
        if (identityHashMap == null) {
            this.typeParameterMatcherGetCache = identityHashMap = new IdentityHashMap();
        }
        return identityHashMap;
    }

    public final Map<Class<?>, Map<String, TypeParameterMatcher>> typeParameterMatcherFindCache() {
        IdentityHashMap identityHashMap = this.typeParameterMatcherFindCache;
        if (identityHashMap == null) {
            this.typeParameterMatcherFindCache = identityHashMap = new IdentityHashMap();
        }
        return identityHashMap;
    }

    public final Map<Class<?>, Boolean> handlerSharableCache() {
        WeakHashMap weakHashMap = this.handlerSharableCache;
        if (weakHashMap == null) {
            this.handlerSharableCache = weakHashMap = new WeakHashMap(4);
        }
        return weakHashMap;
    }

    public final Object indexedVariable(int n2) {
        Object[] objectArray = this.indexedVariables;
        if (n2 < objectArray.length) {
            return objectArray[n2];
        }
        return UNSET;
    }

    public final boolean setIndexedVariable(int n2, Object object) {
        Object[] objectArray = this.indexedVariables;
        if (n2 < objectArray.length) {
            Object object2 = objectArray[n2];
            objectArray[n2] = object;
            return object2 == UNSET;
        }
        this.expandIndexedVariableTableAndSet(n2, object);
        return true;
    }

    private void expandIndexedVariableTableAndSet(int n2, Object object) {
        Object[] objectArray = this.indexedVariables;
        int n3 = this.indexedVariables.length;
        int n4 = n2;
        int n5 = n4 | n4 >>> 1;
        n5 |= n5 >>> 2;
        n5 |= n5 >>> 4;
        n5 |= n5 >>> 8;
        n5 |= n5 >>> 16;
        objectArray = Arrays.copyOf(objectArray, ++n5);
        Arrays.fill(objectArray, n3, objectArray.length, UNSET);
        objectArray[n2] = object;
        this.indexedVariables = objectArray;
    }

    public final Object removeIndexedVariable(int n2) {
        Object[] objectArray = this.indexedVariables;
        if (n2 < objectArray.length) {
            Object object = objectArray[n2];
            objectArray[n2] = UNSET;
            return object;
        }
        return UNSET;
    }

    public final boolean isIndexedVariableSet(int n2) {
        Object[] objectArray = this.indexedVariables;
        return n2 < objectArray.length && objectArray[n2] != UNSET;
    }

    static {
        UNSET = new Object();
        STRING_BUILDER_INITIAL_SIZE = SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.threadLocalMap.stringBuilder.initialSize", 1024);
        logger.debug("-Dio.netty.threadLocalMap.stringBuilder.initialSize: {}", (Object)STRING_BUILDER_INITIAL_SIZE);
        STRING_BUILDER_MAX_SIZE = SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.threadLocalMap.stringBuilder.maxSize", 4096);
        logger.debug("-Dio.netty.threadLocalMap.stringBuilder.maxSize: {}", (Object)STRING_BUILDER_MAX_SIZE);
    }
}

