/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.concurrent;

import com.appoptics.ext.io.netty.util.concurrent.DefaultPromise;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.Promise;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PromiseTask<V>
extends DefaultPromise<V>
implements RunnableFuture<V> {
    private static final Runnable COMPLETED = new SentinelRunnable("COMPLETED");
    private static final Runnable CANCELLED = new SentinelRunnable("CANCELLED");
    private static final Runnable FAILED = new SentinelRunnable("FAILED");
    private Object task;

    PromiseTask(EventExecutor eventExecutor, Runnable runnable, V v2) {
        super(eventExecutor);
        this.task = v2 == null ? runnable : new RunnableAdapter<V>(runnable, v2);
    }

    PromiseTask(EventExecutor eventExecutor, Runnable runnable) {
        super(eventExecutor);
        this.task = runnable;
    }

    PromiseTask(EventExecutor eventExecutor, Callable<V> callable) {
        super(eventExecutor);
        this.task = callable;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    final V runTask() throws Exception {
        Object object = this.task;
        if (object instanceof Callable) {
            return ((Callable)object).call();
        }
        ((Runnable)object).run();
        return null;
    }

    @Override
    public void run() {
        try {
            if (this.setUncancellableInternal()) {
                V v2 = this.runTask();
                this.setSuccessInternal(v2);
            }
            return;
        }
        catch (Throwable throwable) {
            this.setFailureInternal(throwable);
            return;
        }
    }

    private boolean clearTaskAfterCompletion(boolean bl, Runnable runnable) {
        if (bl) {
            this.task = runnable;
        }
        return bl;
    }

    @Override
    public final Promise<V> setFailure(Throwable throwable) {
        throw new IllegalStateException();
    }

    protected final Promise<V> setFailureInternal(Throwable throwable) {
        super.setFailure(throwable);
        this.clearTaskAfterCompletion(true, FAILED);
        return this;
    }

    @Override
    public final boolean tryFailure(Throwable throwable) {
        return false;
    }

    @Override
    public final Promise<V> setSuccess(V v2) {
        throw new IllegalStateException();
    }

    protected final Promise<V> setSuccessInternal(V v2) {
        super.setSuccess(v2);
        this.clearTaskAfterCompletion(true, COMPLETED);
        return this;
    }

    @Override
    public final boolean trySuccess(V v2) {
        return false;
    }

    @Override
    public final boolean setUncancellable() {
        throw new IllegalStateException();
    }

    protected final boolean setUncancellableInternal() {
        return super.setUncancellable();
    }

    @Override
    public boolean cancel(boolean bl) {
        PromiseTask promiseTask = this;
        return promiseTask.clearTaskAfterCompletion(super.cancel(bl), CANCELLED);
    }

    @Override
    protected StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = super.toStringBuilder();
        stringBuilder.setCharAt(stringBuilder.length() - 1, ',');
        return stringBuilder.append(" task: ").append(this.task).append(')');
    }

    private static class SentinelRunnable
    implements Runnable {
        private final String name;

        SentinelRunnable(String string) {
            this.name = string;
        }

        public void run() {
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RunnableAdapter<T>
    implements Callable<T> {
        final Runnable task;
        final T result;

        RunnableAdapter(Runnable runnable, T t2) {
            this.task = runnable;
            this.result = t2;
        }

        @Override
        public final T call() {
            this.task.run();
            return this.result;
        }

        public final String toString() {
            return "Callable(task: " + this.task + ", result: " + this.result + ')';
        }
    }
}

