/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.concurrent;

import com.appoptics.ext.io.netty.util.concurrent.AbstractFuture;
import com.appoptics.ext.io.netty.util.concurrent.BlockingOperationException;
import com.appoptics.ext.io.netty.util.concurrent.DefaultFutureListeners;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.Future;
import com.appoptics.ext.io.netty.util.concurrent.GenericFutureListener;
import com.appoptics.ext.io.netty.util.concurrent.Promise;
import com.appoptics.ext.io.netty.util.internal.InternalThreadLocalMap;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.ThrowableUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPromise<V>
extends AbstractFuture<V>
implements Promise<V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultPromise.class);
    private static final InternalLogger rejectedExecutionLogger = InternalLoggerFactory.getInstance(DefaultPromise.class.getName() + ".rejectedExecution");
    private static final int MAX_LISTENER_STACK_DEPTH = Math.min(8, SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.defaultPromise.maxListenerStackDepth", 8));
    private static final AtomicReferenceFieldUpdater<DefaultPromise, Object> RESULT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultPromise.class, Object.class, "result");
    private static final Object SUCCESS = new Object();
    private static final Object UNCANCELLABLE = new Object();
    private static final CauseHolder CANCELLATION_CAUSE_HOLDER = new CauseHolder(ThrowableUtil.unknownStackTrace(new CancellationException(), DefaultPromise.class, "cancel(...)"));
    private static final StackTraceElement[] CANCELLATION_STACK = DefaultPromise.CANCELLATION_CAUSE_HOLDER.cause.getStackTrace();
    private volatile Object result;
    private final EventExecutor executor;
    private Object listeners;
    private short waiters;
    private boolean notifyingListeners;

    public DefaultPromise(EventExecutor eventExecutor) {
        this.executor = ObjectUtil.checkNotNull(eventExecutor, "executor");
    }

    protected DefaultPromise() {
        this.executor = null;
    }

    @Override
    public Promise<V> setSuccess(V v2) {
        if (this.setSuccess0(v2)) {
            return this;
        }
        throw new IllegalStateException("complete already: " + this);
    }

    @Override
    public boolean trySuccess(V v2) {
        return this.setSuccess0(v2);
    }

    public Promise<V> setFailure(Throwable throwable) {
        if (this.setFailure0(throwable)) {
            return this;
        }
        throw new IllegalStateException("complete already: " + this, throwable);
    }

    @Override
    public boolean tryFailure(Throwable throwable) {
        return this.setFailure0(throwable);
    }

    @Override
    public boolean setUncancellable() {
        if (RESULT_UPDATER.compareAndSet(this, null, UNCANCELLABLE)) {
            return true;
        }
        Object object = this.result;
        return !DefaultPromise.isDone0(object) || !DefaultPromise.isCancelled0(object);
    }

    @Override
    public boolean isSuccess() {
        Object object = this.result;
        return object != null && object != UNCANCELLABLE && !(object instanceof CauseHolder);
    }

    @Override
    public Throwable cause() {
        DefaultPromise defaultPromise = this;
        return defaultPromise.cause0(defaultPromise.result);
    }

    private Throwable cause0(Object object) {
        if (!(object instanceof CauseHolder)) {
            return null;
        }
        if (object == CANCELLATION_CAUSE_HOLDER) {
            object = new LeanCancellationException();
            if (RESULT_UPDATER.compareAndSet(this, CANCELLATION_CAUSE_HOLDER, new CauseHolder((Throwable)object))) {
                return object;
            }
            object = this.result;
        }
        return ((CauseHolder)object).cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> addListener(GenericFutureListener<? extends Future<? super V>> genericFutureListener) {
        ObjectUtil.checkNotNull(genericFutureListener, "listener");
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            this.addListener0(genericFutureListener);
        }
        if (this.isDone()) {
            this.notifyListeners();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> removeListener(GenericFutureListener<? extends Future<? super V>> genericFutureListener) {
        ObjectUtil.checkNotNull(genericFutureListener, "listener");
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            this.removeListener0(genericFutureListener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> await() throws InterruptedException {
        if (this.isDone()) {
            return this;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException(this.toString());
        }
        this.checkDeadLock();
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            while (!this.isDone()) {
                this.incWaiters();
                try {
                    this.wait();
                }
                finally {
                    this.decWaiters();
                }
            }
        }
        return this;
    }

    @Override
    public boolean await(long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.await0(timeUnit.toNanos(l2), true);
    }

    @Override
    public V getNow() {
        Object object = this.result;
        if (object instanceof CauseHolder || object == SUCCESS || object == UNCANCELLABLE) {
            return null;
        }
        return (V)object;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        Object object = this.result;
        if (!DefaultPromise.isDone0(object)) {
            this.await();
            object = this.result;
        }
        if (object == SUCCESS || object == UNCANCELLABLE) {
            return null;
        }
        Throwable throwable = this.cause0(object);
        if (throwable == null) {
            return (V)object;
        }
        if (throwable instanceof CancellationException) {
            throw (CancellationException)throwable;
        }
        throw new ExecutionException(throwable);
    }

    @Override
    public V get(long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        Object object = this.result;
        if (!DefaultPromise.isDone0(object)) {
            if (!this.await(l2, timeUnit)) {
                throw new TimeoutException();
            }
            object = this.result;
        }
        if (object == SUCCESS || object == UNCANCELLABLE) {
            return null;
        }
        Throwable throwable = this.cause0(object);
        if (throwable == null) {
            return (V)object;
        }
        if (throwable instanceof CancellationException) {
            throw (CancellationException)throwable;
        }
        throw new ExecutionException(throwable);
    }

    @Override
    public boolean cancel(boolean bl) {
        if (RESULT_UPDATER.compareAndSet(this, null, CANCELLATION_CAUSE_HOLDER)) {
            if (this.checkNotifyWaiters()) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return DefaultPromise.isCancelled0(this.result);
    }

    @Override
    public boolean isDone() {
        return DefaultPromise.isDone0(this.result);
    }

    public String toString() {
        return this.toStringBuilder().toString();
    }

    protected StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder(64).append(StringUtil.simpleClassName(this)).append('@').append(Integer.toHexString(this.hashCode()));
        Object object = this.result;
        if (object == SUCCESS) {
            stringBuilder.append("(success)");
        } else if (object == UNCANCELLABLE) {
            stringBuilder.append("(uncancellable)");
        } else if (object instanceof CauseHolder) {
            stringBuilder.append("(failure: ").append(((CauseHolder)object).cause).append(')');
        } else if (object != null) {
            stringBuilder.append("(success: ").append(object).append(')');
        } else {
            stringBuilder.append("(incomplete)");
        }
        return stringBuilder;
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    protected void checkDeadLock() {
        EventExecutor eventExecutor = this.executor();
        if (eventExecutor != null && eventExecutor.inEventLoop()) {
            throw new BlockingOperationException(this.toString());
        }
    }

    protected static void notifyListener(EventExecutor eventExecutor, Future<?> future, GenericFutureListener<?> genericFutureListener) {
        DefaultPromise.notifyListenerWithStackOverFlowProtection(ObjectUtil.checkNotNull(eventExecutor, "eventExecutor"), ObjectUtil.checkNotNull(future, "future"), ObjectUtil.checkNotNull(genericFutureListener, "listener"));
    }

    private void notifyListeners() {
        InternalThreadLocalMap internalThreadLocalMap;
        int n2;
        EventExecutor eventExecutor = this.executor();
        if (eventExecutor.inEventLoop() && (n2 = (internalThreadLocalMap = InternalThreadLocalMap.get()).futureListenerStackDepth()) < MAX_LISTENER_STACK_DEPTH) {
            internalThreadLocalMap.setFutureListenerStackDepth(n2 + 1);
            try {
                this.notifyListenersNow();
                return;
            }
            finally {
                internalThreadLocalMap.setFutureListenerStackDepth(n2);
            }
        }
        DefaultPromise.safeExecute(eventExecutor, new Runnable(){

            public void run() {
                DefaultPromise.this.notifyListenersNow();
            }
        });
    }

    private static void notifyListenerWithStackOverFlowProtection(EventExecutor eventExecutor, final Future<?> future, final GenericFutureListener<?> genericFutureListener) {
        InternalThreadLocalMap internalThreadLocalMap;
        int n2;
        if (eventExecutor.inEventLoop() && (n2 = (internalThreadLocalMap = InternalThreadLocalMap.get()).futureListenerStackDepth()) < MAX_LISTENER_STACK_DEPTH) {
            internalThreadLocalMap.setFutureListenerStackDepth(n2 + 1);
            try {
                DefaultPromise.notifyListener0(future, genericFutureListener);
                return;
            }
            finally {
                internalThreadLocalMap.setFutureListenerStackDepth(n2);
            }
        }
        DefaultPromise.safeExecute(eventExecutor, new Runnable(){

            public final void run() {
                DefaultPromise.notifyListener0(future, genericFutureListener);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersNow() {
        Object object;
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            if (this.notifyingListeners || this.listeners == null) {
                return;
            }
            this.notifyingListeners = true;
            object = this.listeners;
            this.listeners = null;
        }
        while (true) {
            if (object instanceof DefaultFutureListeners) {
                this.notifyListeners0((DefaultFutureListeners)object);
            } else {
                DefaultPromise.notifyListener0(this, (GenericFutureListener)object);
            }
            defaultPromise = this;
            synchronized (defaultPromise) {
                if (this.listeners == null) {
                    this.notifyingListeners = false;
                    return;
                }
                object = this.listeners;
                this.listeners = null;
            }
        }
    }

    private void notifyListeners0(DefaultFutureListeners defaultFutureListeners) {
        GenericFutureListener<? extends Future<?>>[] genericFutureListenerArray = defaultFutureListeners.listeners();
        int n2 = defaultFutureListeners.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            DefaultPromise.notifyListener0(this, genericFutureListenerArray[i2]);
        }
    }

    private static void notifyListener0(Future future, GenericFutureListener genericFutureListener) {
        try {
            genericFutureListener.operationComplete(future);
            return;
        }
        catch (Throwable throwable) {
            if (logger.isWarnEnabled()) {
                logger.warn("An exception was thrown by " + genericFutureListener.getClass().getName() + ".operationComplete()", throwable);
            }
            return;
        }
    }

    private void addListener0(GenericFutureListener<? extends Future<? super V>> genericFutureListener) {
        if (this.listeners == null) {
            this.listeners = genericFutureListener;
            return;
        }
        if (this.listeners instanceof DefaultFutureListeners) {
            ((DefaultFutureListeners)this.listeners).add(genericFutureListener);
            return;
        }
        this.listeners = new DefaultFutureListeners((GenericFutureListener)this.listeners, genericFutureListener);
    }

    private void removeListener0(GenericFutureListener<? extends Future<? super V>> genericFutureListener) {
        if (this.listeners instanceof DefaultFutureListeners) {
            ((DefaultFutureListeners)this.listeners).remove(genericFutureListener);
            return;
        }
        if (this.listeners == genericFutureListener) {
            this.listeners = null;
        }
    }

    private boolean setSuccess0(V v2) {
        return this.setValue0(v2 == null ? SUCCESS : v2);
    }

    private boolean setFailure0(Throwable throwable) {
        return this.setValue0(new CauseHolder(ObjectUtil.checkNotNull(throwable, "cause")));
    }

    private boolean setValue0(Object object) {
        if (RESULT_UPDATER.compareAndSet(this, null, object) || RESULT_UPDATER.compareAndSet(this, UNCANCELLABLE, object)) {
            if (this.checkNotifyWaiters()) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    private synchronized boolean checkNotifyWaiters() {
        if (this.waiters > 0) {
            this.notifyAll();
        }
        return this.listeners != null;
    }

    private void incWaiters() {
        if (this.waiters == Short.MAX_VALUE) {
            throw new IllegalStateException("too many waiters: " + this);
        }
        this.waiters = (short)(this.waiters + 1);
    }

    private void decWaiters() {
        this.waiters = (short)(this.waiters - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean await0(long l2, boolean bl) throws InterruptedException {
        if (this.isDone()) {
            return true;
        }
        if (l2 <= 0L) {
            return this.isDone();
        }
        if (bl && Thread.interrupted()) {
            throw new InterruptedException(this.toString());
        }
        this.checkDeadLock();
        long l3 = System.nanoTime();
        long l4 = l2;
        boolean bl2 = false;
        try {
            do {
                DefaultPromise defaultPromise = this;
                synchronized (defaultPromise) {
                    block20: {
                        if (!this.isDone()) break block20;
                        return true;
                    }
                    this.incWaiters();
                    try {
                        this.wait(l4 / 1000000L, (int)(l4 % 1000000L));
                    }
                    catch (InterruptedException interruptedException) {
                        if (bl) {
                            throw interruptedException;
                        }
                        bl2 = true;
                    }
                    finally {
                        this.decWaiters();
                    }
                }
                if (!this.isDone()) continue;
                return true;
            } while ((l4 = l2 - (System.nanoTime() - l3)) > 0L);
            boolean bl3 = this.isDone();
            return bl3;
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static boolean isCancelled0(Object object) {
        return object instanceof CauseHolder && ((CauseHolder)object).cause instanceof CancellationException;
    }

    private static boolean isDone0(Object object) {
        return object != null && object != UNCANCELLABLE;
    }

    private static void safeExecute(EventExecutor eventExecutor, Runnable runnable) {
        try {
            eventExecutor.execute(runnable);
            return;
        }
        catch (Throwable throwable) {
            rejectedExecutionLogger.error("Failed to submit a listener notification task. Event loop shut down?", throwable);
            return;
        }
    }

    private static final class CauseHolder {
        final Throwable cause;

        CauseHolder(Throwable throwable) {
            this.cause = throwable;
        }
    }

    private static final class LeanCancellationException
    extends CancellationException {
        private static final long serialVersionUID = 2794674970981187807L;

        private LeanCancellationException() {
        }

        public final Throwable fillInStackTrace() {
            this.setStackTrace(CANCELLATION_STACK);
            return this;
        }

        public final String toString() {
            return CancellationException.class.getName();
        }
    }
}

