/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.concurrent;

import com.appoptics.ext.io.netty.util.concurrent.AbstractFuture;
import com.appoptics.ext.io.netty.util.concurrent.DefaultPromise;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.Future;
import com.appoptics.ext.io.netty.util.concurrent.GenericFutureListener;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompleteFuture<V>
extends AbstractFuture<V> {
    private final EventExecutor executor;

    protected CompleteFuture(EventExecutor eventExecutor) {
        this.executor = eventExecutor;
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    @Override
    public Future<V> addListener(GenericFutureListener<? extends Future<? super V>> genericFutureListener) {
        DefaultPromise.notifyListener(this.executor(), this, ObjectUtil.checkNotNull(genericFutureListener, "listener"));
        return this;
    }

    @Override
    public Future<V> removeListener(GenericFutureListener<? extends Future<? super V>> genericFutureListener) {
        return this;
    }

    @Override
    public Future<V> await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this;
    }

    @Override
    public boolean await(long l2, TimeUnit timeUnit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return true;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean cancel(boolean bl) {
        return false;
    }
}

